#include "delay.hpp"

delay::delay()
{
  feedback= 1.0f;
  bufsize = 0;
  bufidx = 0;
}

delay::~delay()
{
  if(bufsize != 0)
    delete[] buffer;
}

int delay::getsize()
{
  return bufsize;
}

void delay::setsize(int size) 
{
#ifdef DEBUG
  fprintf(stderr, "delay::setsize(%d)\n", size);
#endif
  if(bufsize != 0)
    delete[] buffer;
  buffer = new float[size];
  bufsize = size;
  bufidx = 0;
}

void delay::mute()
{
  for (int i=0; i<bufsize; i++)
    buffer[i]=0;
}

void delay::setfeedback(float val) 
{
  feedback = val;
}

float delay::getfeedback() 
{
  return feedback;
}

float delay::process(float input)
{
  float bufout;
  
  bufout = buffer[bufidx];
  buffer[bufidx] = feedback*input;
  
  bufidx ++;
  if(bufidx >= bufsize)
    bufidx = 0;

  return bufout;
}

//ends
