// Impulse Response Processor model implementation
//
// Teru KAMOGASHIRA

#ifndef _irmodel_
#define _irmodel_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <fftw3.h>
#include "delay.hpp"

class irmodel
{
public:
  irmodel();
  ~irmodel();
  void loadImpulse(float * inputL, float * inputR, int numsamples);
  void inverseImpulse();
  void processmix(float *inputL, float *inputR,
		  float *outputL, float *outputR,
		  long numsamples, int skip);
  void processreplace(float *inputL, float *inputR,
		      float *outputL, float *outputR,
		      long numsamples, int skip);
  void setwet(float value);
  float getwet();
  void setdry(float value);
  float getdry();
  void setwidth(float value);
  float getwidth();
  int getSampleSize();
  int getLatency();
private:
  void process(float *inputL, float *inputR, float *outputL, float *outputR,
               long numsamples, int skip, char pmode);
  void processSquare(float *inputL, float *inputR, float *outputL, float *outputR);
  void allocImpulse(int numsaples);
  void freeImpulse();
  void update();
  void allocFFT(int numsamples);
  void freeFFT();
  void mute(float * t, int t);
  int checkPow2(int i)
  {
    int p = 2;
    while(p < i)
      p *= 2;
    return p;
  }
  
  int sampleSize, impulseSize;
  float *impulseL, *impulseR;
  float *fftImpulseL, *fftImpulseR;

  int currentProcessSampleSize;
  fftwf_plan planRevL, planRevR;
  float *fftRevL, *fftRevR;
  fftwf_plan planOrigL, planOrigR;
  float *fftOrigL, *fftOrigR;
  
  int current;
  float *delaylineL, *delaylineR;
  int fifoSize;
  float *fifoL, *fifoR;
  float wet,wet1,wet2;

  delay delayL, delayR;
  float dry;
  float width;
  float scalewet;
  float scaledry;
};

#endif
