// NReverb model
// Copyright (C) 2006 Teru KAMOGASHIRA

#ifndef _nrev_
#define _nrev_

#include <stdio.h>
#include <math.h>
#include "comb.hpp"
#include "allpass.hpp"
#include "tuning.h"

class nrev
{
public:
  nrev();
  ~nrev();
  void  resetfs(int fs);
  void  setDefault();
  void	mute();
  void	processmix(float *inputL, float *inputR,
		   float *outputL, float *outputR, long numsamples, int skip);
  void	processreplace(float *inputL, float *inputR,
		       float *outputL, float *outputR, long numsamples, int skip);
  void	setroomsize(float value);
  float	getroomsize();
  void	setfeedback(float value);
  float	getfeedback();
  void	setdamp(float value);
  float	getdamp();
  void	setdamp2(float value);
  float	getdamp2();
  void	setdamp3(float value);
  float	getdamp3();
  void	setwet(float value);
  float	getwet();
  void	setdry(float value);
  float	getdry();
  void	setwidth(float value);
  float	getwidth();
  void	setmode(float value);
  float	getmode();
  void  printconfig();
private:
  void process(float *inputL, float *inputR, float *outputL, float *outputR,
	       long numsamples, int skip, char pmode);
  int   currentfs;
  int   f_(int def, float factor);
  int   p_(int def, float factor);
  bool  isPrime(int number);
  void	update();
  void  allocFilter(int ncomb, int nallpass);
  void  freeFilter();
  void  setFilter(float factor);
  float	gain;
  float	roomsize,roomsize1, feedback;
  float	damp,damp1,damp2,damp3;
  float	wet,wet1,wet2;
  float	dry;
  float	width;
  float	mode;  
  int   numcombs;
  int   numallpasses;
  comb *combL;
  comb *combR;
  allpass *allpassL;
  allpass *allpassR;
  int defaultfs;
};

#endif//_nrev_

//ends
