#include <windows.h>
#include <stdio.h>
#include <vector>

///

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
//#include <arpa/inet.h>
#include <vector>
#include <map>
#include <set>

typedef struct{
  int mode; // 0x1=Normal / 0x6=SysEx
  int r2; // 0x18
  int time; // 0x0
  int r4; // 0
  int SysExLength; // mode==0x1 0 / mode==0x6 byte
  int r6; // 0
  void * dataOrSysEx; // (int) or (void*)
} MidiMessage;

//====

typedef struct{
  short int format;
  short int track;
  short int time;
} MidiHeadChunk;

MidiHeadChunk midiHead;

std::multimap<unsigned long,MidiMessage> midiMessages;
unsigned long maxAbsoluteTime = 0;
unsigned long firstNoteOnTime = 0xffffffff;
unsigned long muteTime = 0;

std::set<unsigned long int> NUM;

void registerMidiEvent(unsigned long absoluteTime, unsigned char * event, size_t eventLength)
{
  //fprintf(stderr, "%08x ", absoluteTime);
  for(int i = 0;i < eventLength;i ++)
    {
      //fprintf(stderr, " %02x", event[i]);
    }
  
  if(event[0] != 0xff)
    {
      NUM.insert(absoluteTime);
      MidiMessage message;
      if(eventLength <= 0x6)
	{
	  message.mode = 0x1;
	  message.SysExLength = 0x0;
	  memcpy(&message.dataOrSysEx, event, eventLength);
	}
      else
	{
	  message.mode = 0x6;
	  message.SysExLength = eventLength;
	  message.dataOrSysEx = (void *)event;
	}
      midiMessages.insert(std::pair<unsigned long,MidiMessage>(absoluteTime, message));
      if(maxAbsoluteTime < absoluteTime)
	maxAbsoluteTime = absoluteTime;
      //fprintf(stdout, ".");
    }
  
  //fprintf(stdout, "\n");
  return;
}

unsigned long varlenParse(unsigned char * mem,
			  size_t * size)
{
  unsigned long val = 0;
  unsigned char r;
  size_t rl = 0;
  do
    {
      r = *mem++;
      rl++;
      val <<= 7;
      val |= 0x7f&r;
    }
  while(rl<5 && r&0x80);
  *size = rl;
  return val;
}

void dumpData(long int * trackLength, unsigned char ** trackData,
	      short int trackSize)
{
  unsigned long int absoluteTime = 0;
  long int dataLength;
  long int current;
  unsigned char * currentTrack;
  unsigned char runningStatus;

  for(int track = 0;track < trackSize;track ++)
    {
      //fprintf(stdout, "Track #%d\n", track);
      
      dataLength = trackLength[track];
      currentTrack = trackData[track];
      current = 0;
      absoluteTime = 0;
      
      while(current < dataLength)
	{
	  unsigned long deltaTime;
	  size_t size;

	  deltaTime =
	    varlenParse(&(currentTrack[current]),
			&size);
	  //fprintf(stderr, "delta %08x[%d]", deltaTime, size);
	  current += size;
	  
	  absoluteTime += deltaTime;
	  //fprintf(stderr, "(%08x)", absoluteTime);
	  
	  if(currentTrack[current] >= 0x80)
	    {
	      //fprintf(stderr, "%02x  ", currentTrack[current]);
	      runningStatus = currentTrack[current];
	    }
	  else
	    {
	      //fprintf(stderr, "%02x->", currentTrack[current]);
	      currentTrack[current-1] = runningStatus;
	      current --;
	    }
	  
	  //fprintf(stderr, "[%02x]", currentTrack[current]);
	  switch(currentTrack[current]&0xf0)
	    {
	    case 0x80:
	    case 0x90:
	    case 0xa0:
	    case 0xb0:
	    case 0xe0:
	      registerMidiEvent(absoluteTime, &(currentTrack[current]), 3);
	      current += 3;
	      break;
	      
	    case 0xc0:
	    case 0xd0:
	      registerMidiEvent(absoluteTime, &(currentTrack[current]), 2);
	      current += 2;
	      break;
	    
	    case 0xf0:
	      //fprintf(stderr, "<%1x>", currentTrack[current]&0xf);
	      unsigned long int orig;
	      unsigned long sysExLength;
	      size_t sizeSysEx;
		  
	      switch (currentTrack[current]&0xf)
		{
		case 0x0:
		  // SysEx
		  // v=current
		  // F0H|ǡĹʲĹ|롼֥ǡ|(F7H)
		  orig = current;
		  sysExLength =
		    varlenParse(&(currentTrack[current+1]),
				&sizeSysEx);
		  memmove(&(currentTrack[orig+1]), &(currentTrack[orig+1+sizeSysEx]), sysExLength);
		  registerMidiEvent(absoluteTime, &(currentTrack[current]), sysExLength);
		  
		  current += sizeSysEx+sysExLength;
		  break;
		  
		case 0x8:
		case 0xa:
		case 0xb:
		case 0xc:
		  registerMidiEvent(absoluteTime, &(currentTrack[current]), 1);
		  current ++;
		  break;
		  
		case 0xf:
		  orig = current;
		  current+= 2;
		  current += currentTrack[current]+1;
		  registerMidiEvent(absoluteTime, &(currentTrack[orig]), current-orig);
		  break;

		case 0x7:
		  // SysEx
		  // v=current
		  // F7H|ǡĹʲĹ|롼֥ǡ
		  orig = current;
		  sysExLength =
		    varlenParse(&(currentTrack[current+1]),
				&sizeSysEx);
		  memmove(&(currentTrack[orig+1]), &(currentTrack[orig+1+sizeSysEx]), sysExLength);
		  currentTrack[orig+1+sizeSysEx+sysExLength] = 0xF7;
		  registerMidiEvent(absoluteTime, &(currentTrack[current]), sysExLength);
		  
		  current += sizeSysEx+sysExLength;
		  break;
		  
		default:
		  fprintf(stderr, "Unknown Meta Event.\n");
		}
	      break;
	      
	    default:
	      fprintf(stderr, "Invalid status.\n");
	      //exit(-1);
	    }
	  fprintf(stderr, "\r");	  
	}
    }
}

int dump(char * fileName)
{
  char buf[1024];
  FILE * fp = NULL;
  short int tmpsi;
  long int tmpli;
  unsigned char ** trackData;
  long int * trackLength;
  
  if((fp = fopen(fileName ,"rb")) == NULL)
    {
      fprintf(stderr, "!fopen(%s)\n" ,fileName);
      return -1;
    }

  if(fread(buf, 1, 8, fp) != 8)
    return -1;
  if(strncmp(buf, "MThd\0\0\0\6", 8) != 0)
    {
      fprintf(stderr, "!MThd0006\n");
      goto err;
    }

  if(fread(&tmpsi, 1, 2, fp) != 2)
    return -1;  
  midiHead.format = ntohs(tmpsi);

  if(fread(&tmpsi, 1, 2, fp) != 2)
    return -1;  
  midiHead.track = ntohs(tmpsi);

  if(fread(&tmpsi, 1, 2, fp) != 2)
    return -1;  
  midiHead.time = ntohs(tmpsi);
  
  fprintf(stderr, "%04x %04x %04x\n",
	  midiHead.format, midiHead.track, midiHead.time);
  
  trackData = new unsigned char*[midiHead.track];
  trackLength = new long int[midiHead.track];
  
  for(int track = 0;track < midiHead.track;track ++)
    {
      fprintf(stderr, "Track #%d", track);
      if(fread(buf, 1, 4, fp) != 4)
	return -1;
      if(memcmp(buf, "MTrk", 4) != 0)
	{
	  fprintf(stderr, "!MTrk\n");
	  goto err;
	}

      if(fread(&tmpli, 1, 4, fp) != 4)
	return -1;
      trackLength[track] = ntohl(tmpli);
      fprintf(stderr, " %d\n", trackLength[track]);

      trackData[track] = new unsigned char[trackLength[track]];

      if(fread(trackData[track], 1, trackLength[track], fp)
	 != trackLength[track])
	return -1;
    }

  dumpData(trackLength, trackData, midiHead.track);
  
  /*
    for(int track = 0;track < midiHead.track;track ++)
    {
    //delete[]  trackData[track];
    }
  */
  
  //delete[] trackLength;
  //delete[] trackData;
  err:
  fclose(fp);
  return 0;
}

int main_TMP(int argc, char *argv[])
{
  if(argc > 1)
    {
      dump(argv[1]);
      
      int sizeT;
      for(unsigned long int atime = 0;atime < maxAbsoluteTime;atime ++)
	{
	  fprintf(stderr, "%08x/%08x", atime, maxAbsoluteTime);
	  
	  sizeT=0;
	  std::pair<std::multimap<unsigned long int,MidiMessage>::iterator,
	    std::multimap<unsigned long int,MidiMessage>::iterator> p = midiMessages.equal_range(atime);
	  std::multimap<unsigned long int,MidiMessage>::iterator it;
	  for(it = p.first;it != p.second;it ++)
	    {
	      sizeT++;
	    }
	  fprintf(stderr, ": %d", sizeT);
	  if(sizeT != 0)
	    fprintf(stderr, "\n");
	  else
	    fprintf(stderr, "\r");
	}
      
    }
  return 0;
}


///====

typedef struct{
  int r1; // "PtsV"
  void *r2, *r3, *r4, *r5;
  int r7[15];
  void *r8;
} SGPFunctionTable;

typedef struct{
  int r1; // 0 (Size Of Pointers)
  void * r2; // 0xBAADF00D -> struct{(void*)function[2]}
  void * r3; // -> MidiMessage
  // ...
} MInfo;
/*
typedef struct{
  int mode; // 0x1=Normal / 0x6=SysEx
  int r2; // 0x18
  int r3; // 0x0
  int r4; // 0
  int SysExLength; // mode==0x1 0 / mode==0x6 byte
  int r6; // 0
  void * dataOrSysEx; // (int) or (void*)
} MidiMessage;
*/
typedef struct{
  SGPFunctionTable * r1; // -> SGPFunctionTable
  /*
    Event code
    0 1 ... f
    13 16 17 18 19 ... 1f
    20 ... 2f
    30 ... 3f
    40 ... 44
  */
  void * r2; // eventcode 19 -> MInfo
  void * r3; // 0
  void * r4; // 0
  MInfo * r5; // ->MInfo
  void * r6; // 0
} EventCall;

typedef struct{
  unsigned char * L; // < 0x113A*4 (float *)[]
  unsigned char * R; // < 0x113A*4
} WavData;

typedef struct{
  SGPFunctionTable * r1; // -> SGPFunctionTable
  void * r2; // 0
  WavData * r3;
  int size;
} ReadData;

SGPFunctionTable * initSgpDll(char * dllPath, char * procNameOrOrdinal,
		      HINSTANCE * hModule, void * sgpInitFunction)
{
  typedef int (*SGPMAIN)(void*);
  SGPMAIN sgpMain = NULL;
  
  if((*hModule = LoadLibraryA(dllPath)) == NULL)
    {
      fprintf(stderr, "!LoadLibraryA(%s)\n", dllPath);
      return 0;
    }
  if((sgpMain = (SGPMAIN)GetProcAddress(*hModule, procNameOrOrdinal)) == NULL)
    {
      fprintf(stderr, "!GetProcAddress(%s)\n", procNameOrOrdinal);
      return 0;
    }
  return (SGPFunctionTable *) sgpMain((void*)sgpInitFunction);
}

// MidiOut.dll 0175A0E0
typedef struct{
  void * r1;
  int mode;
  void * r3;
  void * r4;
  void * r5;
  void * r6;
} SGPInit;
int __cdecl sgpInit(SGPInit sgp)
{
  char yid[] = "YAMAHA";
  char cid[] = "Cubase VST";

  fprintf(stderr, "sgpInit()\n");
  fprintf(stderr, "<%08x>[%08x]<%08x><%08x><%08x><%08x>\n",
	  sgp.r1, sgp.mode, sgp.r3, sgp.r4, sgp.r5, sgp.r6);
  switch(sgp.mode)
    {
    case 0x1:
      return 2;
      
    case 0x2:
      return 0x6D723220;
      
    case 0x3:
      return 1;
      
    case 0x20:
      memcpy(sgp.r5, yid, sizeof(yid));
      return 0;

    case 0x21:
      memcpy(sgp.r5, cid, sizeof(cid));
      return 0;

    case 0x22:
      return 0x3E8;

    case 0xE:

    case 0x2A:

    case 0x26:
      return 1;
      
    default:
      return 0;
    }
}

int MidiReadData(SGPFunctionTable * r1, ReadData readData, int size)
{
  readData.size = size;
  typedef int (*TA)(ReadData);
  TA ta = (int (*)(ReadData))r1->r8;
  // MidiOut.dll 0175B178 FF50 50 CALL DWORD PTR DS:[EAX+50]
  //             0175B17B 83C4 10 ADD ESP,10
  int ret = ta(readData);
  //fprintf(stderr, "ReadData()=%02x\n", ret);
  return ret;
}

int MidiEventCall(SGPFunctionTable * r1,
		  int r2, int r3, int r4, MInfo * r5, int r6)
{
  /*
    if(r2 == 0x19)
    {
    fprintf(stderr, "%d", r5->r1);
    if(r5->r1 != 0)
    {
    fprintf(stderr, "[%08x]", ((MidiMessage*)r5->r3)->dataOrSysEx);
    }
    }
  */
  
  EventCall f;
  f.r1 = r1;
  f.r2 = (void*)r2;
  f.r3 = (void*)r3;
  f.r4 = (void*)r4;
  f.r5 = r5;
  f.r6 = (void*)r6;
    
  typedef int (*TA)(EventCall);
  TA ta = (int (*)(EventCall))r1->r2;

  // MidiOut.dll 0175B138 FF50 04 CALL DWORD PTR DS:[EAX+4]
  //             0175B13B 83C4 18 ADD ESP,18
  int ret = ta(f);
  //fprintf(stderr, "EventCall(%02x)=%02x\n", f.r2, ret);
  return ret;
}

// Float 32 bit Little Endian
// mute = 00 00 00 80 ...
void dump(unsigned char * at, int size)
{
  for(int i = 0;i < size*4; i+=4)
    {
      fprintf(stdout, "%c%c%c%c", at[i], at[i+1], at[i+2], at[i+3]);
    }
}

void dumpW(WavData * at, int size)
{
  for(int i = 0;i < size*4; i+=4)
    {
      fprintf(stdout, "%c%c%c%c%c%c%c%c",
	      at->L[i], at->L[i+1], at->L[i+2], at->L[i+3],
	      at->R[i], at->R[i+1], at->R[i+2], at->R[i+3]);
    }
}

int __fastcall main_(int argc, char * argv[])
{
  char * FileName = NULL;
  char * ProcNameOrOrdinal;
  char dFileName[] = "SGP.DLL";
  char dProcNameOrOrdinal[] = "main";
  char * midiFileName;
  HINSTANCE hModule;

  if(argc > 2)
    {
      fprintf(stderr, "Using %s(%s)\n", argv[1], argv[2]);
      FileName = argv[1];
      ProcNameOrOrdinal = argv[2];
      midiFileName = argv[3];
    }
  else
    {
      FileName = dFileName;
      ProcNameOrOrdinal = dProcNameOrOrdinal;
      midiFileName = argv[1];
    }

  SGPFunctionTable * sgpTable = initSgpDll(FileName, ProcNameOrOrdinal,
				   &hModule, (void *)sgpInit);
  if(sgpTable == 0)
    {
      fprintf(stderr, "!initSgpDll()\n");
      return -1;
    }
  
  fprintf(stderr, "===  SgpTable at %08x ===\n", sgpTable);
  fprintf(stderr, "MagicCode\t[%08x]\n",sgpTable->r1);
  fprintf(stderr,"<%08x>\tMidiEventCall()\n", sgpTable->r2);
  fprintf(stderr,"<%08x>\tMidiReadData()\n", sgpTable->r8);
  fprintf(stderr, "<%08x><%08x><%08x>\n",sgpTable->r3, sgpTable->r4, sgpTable->r5);

  for(int i = 0;i < sizeof(sgpTable->r7)/sizeof(sgpTable->r7[0]);i ++)
    {
      fprintf(stderr, "%02x\t[%08x]\n", i, sgpTable->r7[i]);
    }

  WavData wavData;
  unsigned char L[0x8000];
  unsigned char R[0x8000];
  wavData.L = L;
  wavData.R = R;

  ReadData readData;
  readData.r1 = sgpTable;
  readData.r3 = &wavData;
  readData.size = 0x113A;
  
  // C 1 23 0 2 A,0,0,0,472C4400 B,0,113A C,0,1 2
  MidiEventCall(sgpTable, 0x23, 0, 0,      0, 0);
  MidiEventCall(sgpTable, 0x00, 0, 0,      0, 0);
  MidiEventCall(sgpTable, 0x02, 0, 0,      0, 0);
  MidiEventCall(sgpTable, 0x0A, 0, 0,      0, 0x47C24400);
  MidiEventCall(sgpTable, 0x0B, 0, 0x113A, 0, 0); // Default ReadData Range
  MidiEventCall(sgpTable, 0x0C, 0, 0x1,    0, 0);
  MidiEventCall(sgpTable, 0x02, 0, 0,      0, 0);

  MidiMessage mm;
  MInfo minfo;
  minfo.r1 = 1;
  minfo.r3 = (void*)&mm;
  
  unsigned char gmReset[] = {0xf0, 0x7e, 0x7f, 0x09, 0x01, 0xf7};

  mm.mode = 0x6;
  mm.r2 = 0x18;
  mm.SysExLength = 0x6;
  mm.dataOrSysEx = (void*)gmReset;

  //MidiEventCall(sgpTable, 0x19, 0, 0, &minfo, 0);
  //MidiReadData(sgpTable, readData, 0x113A);
  //dumpW(&wavData, 0x113A);
  //MidiReadData(sgpTable, readData, 0x2C);
  //dumpW(&wavData, 0x2C);

  minfo.r1 = 0;
  MidiEventCall(sgpTable, 0x19, 0, 0, &minfo, 0);
  MidiReadData(sgpTable, readData, 0x113A);
  dumpW(&wavData, 0x113A);
  MidiReadData(sgpTable, readData, 0x2C);
  dumpW(&wavData, 0x2C);


  ///
  
  dump(midiFileName);
  void ** MMINFO;
  MidiMessage * mmp;
  int sizeT;

  std::set<long unsigned int>::iterator itff = NUM.begin();

  double hTime = midiHead.time;
  double paraB = 0x180*0x30;
  int para = paraB/hTime;

  double preciseTime = 0.0;
  long unsigned int readB = 0;
  
  //preciseTime = atime*midiHead.time;
  
  for(unsigned long int atime = 0;atime < maxAbsoluteTime;atime ++)
    {
      sizeT=0;
      std::pair<std::multimap<unsigned long int,MidiMessage>::iterator,
	std::multimap<unsigned long int,MidiMessage>::iterator> p = midiMessages.equal_range(atime);
      std::multimap<unsigned long int,MidiMessage>::iterator it;
      for(it = p.first;it != p.second;it ++)
	{
	  sizeT++;
	}
      
  
      fprintf(stderr, "%d\r", atime);
      
      if(sizeT != 0)
	{
	  fprintf(stderr, "%d\n", atime);
	  itff++;
	  if((*itff - atime) > 0x1000)
	    {
	      atime = (*itff) - 1;
	    }
	  
	  int op;
	  //fprintf(stderr, "%08x/%08x", atime, maxAbsoluteTime);
	  MMINFO = new void*[sizeT+2];
	  MMINFO[0] = (void *)sizeT;
	  //MMINFO[0] = 0;
	  MMINFO[1] = (void *)0xBAADF00D;
	  mmp = new MidiMessage[sizeT];
	  //fprintf(stderr, "\n");
	  op = 2;
	  for(it = p.first;it != p.second;it ++)
	    {
	      mmp[op-2] = (*it).second;
	      //MMINFO[op] = &(mmp[op-2]);
	      MMINFO[op] = &((*it).second);
	      op ++;
	    }

	  // 0030 -> 0x180
	  // 0180 -> 0x60
	  MidiEventCall(sgpTable, 0x19, 0, 0, (MInfo *)MMINFO, 0);
	  MidiReadData(sgpTable, readData, para);
	  dumpW(&wavData, para);
	  
	  delete[] MMINFO;
	  delete[] mmp;
	}
      else
	{
	  MMINFO = new void*[2];
	  MMINFO[0] = 0;
	  MMINFO[1] = (void *)0xBAADF00D;
	  
	  MidiEventCall(sgpTable, 0x19, 0, 0, (MInfo *)MMINFO, 0);
	  MidiReadData(sgpTable, readData, para);
	  dumpW(&wavData, para);
	  
	  delete[] MMINFO;
	}
    }
 
  
  while(1)
    {
      minfo.r1 = 1;
      mm.mode = 0x1;
      mm.time = 0x0;
      mm.SysExLength = 0x0;  
      mm.dataOrSysEx = (void*)0x00643C90;
      
      MidiEventCall(sgpTable, 0x19, 0, 0, &minfo, 0);
      MidiReadData(sgpTable, readData, 0x1000);
      dumpW(&wavData, 0x1000);
      
      mm.dataOrSysEx = (void*)0x00644090;
      MidiEventCall(sgpTable, 0x19, 0, 0, &minfo, 0);
      MidiReadData(sgpTable, readData, 0x1000);
      dumpW(&wavData, 0x1000);
      
      mm.time=0x0;
      mm.dataOrSysEx = (void*)0x00644390;
      MidiEventCall(sgpTable, 0x19, 0, 0, &minfo, 0);
      MidiReadData(sgpTable, readData, 0x1000);
      dumpW(&wavData, 0x1000);
      
      minfo.r1 = 0;
      MidiEventCall(sgpTable, 0x19, 0, 0, &minfo, 0);
      MidiReadData(sgpTable, readData, 0x1000);
      dumpW(&wavData, 0x1000);

      MidiEventCall(sgpTable, 0x19, 0, 0, &minfo, 0);
      MidiReadData(sgpTable, readData, 0x1000);
      dumpW(&wavData, 0x1000);

      MidiEventCall(sgpTable, 0x19, 0, 0, &minfo, 0);
      MidiReadData(sgpTable, readData, 0x1000);
      dumpW(&wavData, 0x1000);
    }
  
  // Last
  MidiEventCall(sgpTable, 0x0C, 0, 0x0, 0, 0);
  MidiEventCall(sgpTable, 0x01, 0, 0x0, 0, 0);

  FreeLibrary(hModule);
  
  return 0;
}

int main(int argc, char * argv[])
{
  return main_(argc,argv);
}
