/*
 * 
 *  libSGP.h - VSTi loading code
 * 
 *  Copyright (C) 2006 Teru KAMOGASHIRA
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

#include <windows.h>
#include <stdio.h>
#include <vector>
#include <string>
#include <math.h>

// DLL specific structure

typedef struct{
  void * r1;
  int mode;
  void * r3, * r4, * r5, * r6;
} SGPInit;

typedef struct{
  int r1; // "PtsV" (LittleEndian)
  void *r2; // dispatcher
  void *r3; // process
  void *r4; // setParameter
  void *r5; // getParameter
  long int r6; // numPrograms
  long int r7; // numParams
  long int r10; // numInputs
  long int r11; // numOutpus
  long int r12; // flags
  int r_[10];
  void *r8; // replace
} SGPFunctionTable;

typedef struct{
  int r1; // 0 (Size Of Pointers)
  void * r2; // 0xBAADF00D -> struct{(void*)function[2]}
  void * r3; // -> MidiMessage[0]
  // -> MidiMessage[1] ... -> MidiMessage[sizeOfPointers]
} MInfo;

typedef struct{
  int mode; // 0x1=Normal / 0x6=SysEx
  int r2; // 0x18
  int byte; // offset+byte
  int r4; // 0
  int SysExLength; // mode==0x1 0 / mode==0x6 byte
  int r6; // 0
  void * dataOrSysEx; // (int) or (void*)
} MidiMessage;

typedef struct{
  SGPFunctionTable * sgpFunctionTable;
  void * r2; // eventcode 19 -> MInfo (opcode) AEffect/AEffectX
  void * r3; // 0
  void * r4; // 0
  MInfo * r5; // ->MInfo
  void * r6; // 0
} EventCall;

typedef struct{
  unsigned char * L;
  unsigned char * R;
} WavData;

typedef struct{
  SGPFunctionTable * sgpFunctionTable;
  void * r2; // 0
  WavData * r3;
  int size;
} ReadData;

// libSGP specific structure

typedef struct{
  long int relativeByte;
  std::string midiMessage;
} MFrame;

class libSGP{
 private:
  HINSTANCE SGPInstance;
  SGPFunctionTable * sgpFunctionTable;
  static int __cdecl sgpInit(SGPInit sgp);
  int MidiEventCall(EventCall * eventCall);
  int MidiReadData(ReadData * readData);
  int MidiAddData(ReadData * readData);

 public:
  void dumpLR(unsigned char * L, unsigned char * R, int size, FILE * fp);
  void dumpLR_S24(unsigned char * L, unsigned char * R, int size, FILE * fp);
  void dumpLR_S32(unsigned char * L, unsigned char * R, int size, FILE * fp);
  int loadSgpDll(char * dllPath, char * procNameOrOrdinal);
  int eventCall(int eventCode, int r2, int r3, int r4, int r5);
  int playFrame(std::vector<MFrame> mFrame,
	        unsigned char * L, unsigned char * R, int size);
};
