#include "libSGP.h"

int __cdecl libSGP::sgpInit(SGPInit sgp)
{
  char yid[] = "YAMAHA";
  char cid[] = "Cubase VST";
#ifdef DEBUG
  fprintf(stderr, "sgpInit():<%08x>[%08x]<%08x><%08x><%08x><%08x>\n",
	  sgp.r1, sgp.mode, sgp.r3, sgp.r4, sgp.r5, sgp.r6);
#endif
  switch(sgp.mode)
    {
    case 0x1:
      return 2;
      
    case 0x2:
      return 0x6D723220;
      
    case 0x3:
      return 1;
      
    case 0x20:
      memcpy(sgp.r5, yid, sizeof(yid));
      return 0;

    case 0x21:
      memcpy(sgp.r5, cid, sizeof(cid));
      return 0;

    case 0x22:
      return 0x3E8;

    case 0xE:
      
    case 0x2A:

    case 0x26:
      return 1;
      
    default:
      return 0;
    }
}

int libSGP::loadSgpDll(char * dllPath, char * procNameOrOrdinal)
{
  typedef int __cdecl (*SGPI)(SGPInit);
  typedef SGPFunctionTable*(*SGPMAIN)(SGPI);
  SGPMAIN sgpMain;
  
  if((SGPInstance = LoadLibraryA(dllPath)) == NULL)
    {
      fprintf(stderr, "!LoadLibraryA(%s)\n", dllPath);
      return -1;
    }
  if((sgpMain = (SGPMAIN)GetProcAddress(SGPInstance, procNameOrOrdinal)) == NULL)
    {
      fprintf(stderr, "!GetProcAddress(%s)\n", procNameOrOrdinal);
      return -1;
    }
  sgpFunctionTable = sgpMain(&libSGP::sgpInit);
  if(sgpFunctionTable == 0)
    {
      fprintf(stderr, "!%s Internal Error or Version Mismatch.\n", dllPath);
      return -1;
    }
  fprintf(stderr, "sgpFunctionTable at %08x\n", sgpFunctionTable);
  return 0;
}

int libSGP::MidiReadData(ReadData * readData)
{
  typedef int (*TA)(ReadData);
  TA ta = (int (*)(ReadData))sgpFunctionTable->r8;
  return ta(*readData);
}

int libSGP::MidiEventCall(EventCall * eventCall)
{
  typedef int (*TA)(EventCall);
  TA ta = (int (*)(EventCall))sgpFunctionTable->r2;
  return ta(*eventCall);
}

int libSGP::eventCall(int eventCode, int r2, int r3, int r4, int r5)
{
  EventCall eventCall;
  eventCall.sgpFunctionTable = sgpFunctionTable;
  eventCall.r2 = (void *)eventCode;
  eventCall.r3 = (void *)r2;
  eventCall.r4 = (void *)r3;
  eventCall.r5 = (MInfo *)r4;
  eventCall.r6 = (void *)r5;
  return MidiEventCall(&eventCall);
}

int libSGP::playFrame(std::vector<MFrame> mFrame,
		      unsigned char * L, unsigned char * R, int size)
{
  // build MInfo
  void ** mInfo = new void*[mFrame.size()+2];
  mInfo[0] = (void *)mFrame.size();
  mInfo[1] = (void *)0xBAADF00D;
  MidiMessage * midiMessages = new MidiMessage[mFrame.size()];

  for(int i = 0;i < (int)mFrame.size();i ++)
    {
      mInfo[2+i] = (void *)&(midiMessages[i]);
      midiMessages[i].byte = mFrame[i].relativeByte;
      midiMessages[i].r2 = 0x18;
      midiMessages[i].r4 = 0x0;
      midiMessages[i].r6 = 0x0;
      if(mFrame[i].midiMessage.size() <= 0x3)
	{
	  midiMessages[i].mode = 0x1;
	  midiMessages[i].SysExLength = 0x0;
	  memcpy(&(midiMessages[i].dataOrSysEx),
		 mFrame[i].midiMessage.c_str(),
		 mFrame[i].midiMessage.size());
	}
      else
	{
	  midiMessages[i].mode = 0x6;
	  midiMessages[i].SysExLength = mFrame[i].midiMessage.size();
	  midiMessages[i].dataOrSysEx = (void *)mFrame[i].midiMessage.c_str();
	}
    }
  
  EventCall eventCall;
  eventCall.sgpFunctionTable = sgpFunctionTable;
  eventCall.r2 = (void *)0x19;
  eventCall.r3 = eventCall.r4 = eventCall.r6 = 0x0;
  eventCall.r5 = (MInfo *)mInfo;
  MidiEventCall(&eventCall);
  
  WavData wavData;
  wavData.L = L;
  wavData.R = R;  
  ReadData readData;
  readData.sgpFunctionTable = sgpFunctionTable;
  readData.r2 = 0x0;
  readData.r3 = &wavData;
  readData.size = size;
  MidiReadData(&readData);
  delete[] midiMessages;
  delete[] mInfo;
  return 0;
}

void libSGP::dumpLR(unsigned char * L, unsigned char * R, int size)
{
  for(int i = 0;i < size*4; i+=4)
    {
      fprintf(stdout, "%c%c%c%c%c%c%c%c",
              L[i], L[i+1], L[i+2], L[i+3],
              R[i], R[i+1], R[i+2], R[i+3]);
    }
}
