#include <windows.h>
#include <stdio.h>
#include <vector>
#include <string>

// DLL specific structure

typedef struct{
  void * r1;
  int mode;
  void * r3, * r4, * r5, * r6;
} SGPInit;

typedef struct{
  int r1; // "PtsV"
  void *r2, *r3, *r4, *r5;
  int r7[15];
  void *r8;
} SGPFunctionTable;

typedef struct{
  int r1; // 0 (Size Of Pointers)
  void * r2; // 0xBAADF00D -> struct{(void*)function[2]}
  void * r3; // -> MidiMessage[0]
  // -> MidiMessage[1] ... -> MidiMessage[sizeOfPointers]
} MInfo;

typedef struct{
  int mode; // 0x1=Normal / 0x6=SysEx
  int r2; // 0x18
  int byte; // offset+byte
  int r4; // 0
  int SysExLength; // mode==0x1 0 / mode==0x6 byte
  int r6; // 0
  void * dataOrSysEx; // (int) or (void*)
} MidiMessage;

typedef struct{
  SGPFunctionTable * sgpFunctionTable;
  /*
    Event code
    0 1 ... f 13 16 17 18 19 ... 1f
    20 ... 2f 30 ... 3f 40 ... 44
  */
  void * r2; // eventcode 19 -> MInfo
  void * r3; // 0
  void * r4; // 0
  MInfo * r5; // ->MInfo
  void * r6; // 0
} EventCall;

typedef struct{
  unsigned char * L;
  unsigned char * R;
} WavData;

typedef struct{
  SGPFunctionTable * sgpFunctionTable;
  void * r2; // 0
  WavData * r3;
  int size;
} ReadData;

// libSGP specific structure

typedef struct{
  long int relativeByte;
  std::string midiMessage;
} MFrame;

class libSGP{
 private:
  HINSTANCE SGPInstance;
  SGPFunctionTable * sgpFunctionTable;
  static int __cdecl sgpInit(SGPInit sgp);
  int MidiEventCall(EventCall * eventCall);
  int MidiReadData(ReadData * readData);
 public:
  void dumpLR(unsigned char * L, unsigned char * R, int size);
  int loadSgpDll(char * dllPath, char * procNameOrOrdinal);
  int eventCall(int eventCode, int r2, int r3, int r4, int r5);
  int playFrame(std::vector<MFrame> mFrame,
	        unsigned char * L, unsigned char * R, int size);
};
