using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.IO.Ports;
using System.Text.RegularExpressions;

namespace avrdudeGUI {
    
    public partial class MainForm : Form {

        /// <summary>
        /// avrdude.exe t@CI{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void AvrdudeButton_Click(object sender, EventArgs e) {

            OpenFileDialog.CheckFileExists = true;
            OpenFileDialog.Filter = "avrdude.exe|avrdude.exe";
            OpenFileDialog.FileName = "";
            OpenFileDialog.Title = "Select avrdude.exe File";
            OpenFileDialog.ShowDialog();
            if (OpenFileDialog.FileName.Length > 0) {
                AvrdudeTextBox.Text = OpenFileDialog.FileName;
                AvrdudeInfo();  // R{{bNXݒ
            }
        }

        /// <summary>
        /// `bv{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ChipEraseButton_Click(object sender, EventArgs e) {

            if (MessageBox.Show("All the settings and data in the device are deleted. Is it good ?", this.Text,
                MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2)
                == DialogResult.Yes) {
                ExecCommand("-e", 50, false);
            }
        }

        /// <summary>
        /// ^[~i[h{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void TerminalButton_Click(object sender, EventArgs e) {

            if (AvrdudeTextBox.Text.Length == 0) {
                MessageBox.Show("Select avrdude.exe File", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                AvrdudeButton.Focus();
                return;
            }
            if (ProgrammerComboBox.SelectedIndex < 0) {
                MessageBox.Show("Select Programmer", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                ProgrammerComboBox.Focus();
                return;
            }
            if (DeviceComboBox.SelectedIndex < 0) {
                MessageBox.Show("Select Device", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                DeviceComboBox.Focus();
                return;
            }

            System.Diagnostics.Process prc = null;
            System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
            psi.FileName = System.Environment.GetEnvironmentVariable("comspec");
            psi.Arguments = " /K \"" + AvrdudeTextBox.Text + "\" "; // IĂ Windows CloseȂ
            psi.Arguments += GetArg();
            psi.Arguments += " -t";
            prc = System.Diagnostics.Process.Start(psi);
            prc.WaitForExit();
        }


        /// <summary>
        /// q[Yǂݍ݃{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ReadFuseButton_Click(object sender, EventArgs e) {
            string hfuse;
            string lfuse;
            string efuse;
            StreamReader sr;
            string data;
            string temp;

            HFuseTextBox.Text = "";
            LFuseTextBox.Text = "";
            EFuseTextBox.Text = "";

            hfuse = "_hfuse_.txt";
            lfuse = "_lfuse_.txt";
            efuse = "_efuse_.txt";
            temp = Environment.GetEnvironmentVariable("temp") + "\\";

            File.Delete(temp + hfuse);
            File.Delete(temp + lfuse);
            File.Delete(temp + efuse);

            // hfuse  lfuse ǂݍ
            if (ExecCommand("-U hfuse:r:" + hfuse + ":h -U lfuse:r:" + lfuse + ":h",
                150, false) == 0) {

                if (File.Exists(temp + hfuse)) {
                    sr = new StreamReader(temp + hfuse);
                    data = sr.ReadLine();
                    if (data.Length == 3){
                        HFuseTextBox.Text = "0" + data.Substring(2, 1).ToUpper();
                    } else if (data.Length == 4){
                        HFuseTextBox.Text = data.Substring(2, 2).ToUpper();
                    }
                    sr.Close();
                }
                if (File.Exists(temp + lfuse)) {
                    sr = new StreamReader(temp + lfuse);
                    data = sr.ReadLine();
                    if (data.Length == 3){
                        LFuseTextBox.Text = "0" + data.Substring(2, 1).ToUpper();
                    } else if (data.Length == 4){
                        LFuseTextBox.Text = data.Substring(2, 2).ToUpper();
                    }
                    sr.Close();
                }

                // AVRISPmkIȈꍇ͎ԑ҂Kv???
                System.Windows.Forms.Cursor cur = System.Windows.Forms.Cursor.Current;
                System.Windows.Forms.Cursor.Current = Cursors.WaitCursor;   // vJ[\
                System.Threading.Thread.Sleep(500);
                System.Windows.Forms.Cursor.Current = cur;  // J[\߂

                // efuse ̖foCX̂ŃG[͖
                if (ExecCommand("-U efuse:r:" + efuse + ":h", 50, true) == 0)
                {
                        if (File.Exists(temp + efuse))
                        {
                            sr = new StreamReader(temp + efuse);
                            data = sr.ReadLine();
                            if (data.Length == 3)
                            {
                                EFuseTextBox.Text = "0" + data.Substring(2, 1).ToUpper();
                            }
                            else if (data.Length == 4)
                            {
                                EFuseTextBox.Text = data.Substring(2, 2).ToUpper();
                            }
                            sr.Close();
                        }
                }
            }
            File.Delete(temp + hfuse);
            File.Delete(temp + lfuse);
            File.Delete(temp + efuse);
        }

        /// <summary>
        /// q[Y݃{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void WriteFuseButton_Click(object sender, EventArgs e) {

            Regex reg = new Regex("^[0-9A-Fa-f]{2}$");

            if ((HFuseTextBox.Text.Length > 0) && (reg.Match(HFuseTextBox.Text).Success == false)) {
                MessageBox.Show("Please Set hfuse by the hexadecimal number of 2 charactors. ",
                    this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                HFuseTextBox.Focus();
                return;
            }
            if ((LFuseTextBox.Text.Length > 0) && (reg.Match(LFuseTextBox.Text).Success == false)) {
                MessageBox.Show("Please Set lfuse by the hexadecimal number of 2 charactors. ",
                    this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                LFuseTextBox.Focus();
                return;
            }
            if ((EFuseTextBox.Text.Length > 0) && (reg.Match(EFuseTextBox.Text).Success == false)) {
                MessageBox.Show("Please Set efuse by the hexadecimal number of 2 charactors. ",
                    this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                EFuseTextBox.Focus();
                return;
            }
            if ((HFuseTextBox.Text.Length == 0) && (LFuseTextBox.Text.Length == 0) && (EFuseTextBox.Text.Length == 0)) {
                MessageBox.Show("Please Set hfuse, lfuse or efuse.", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }

            if (MessageBox.Show("Fuses is ReWritten. Is it good ?",
                this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2)
                != DialogResult.Yes) return;

            int max = 50;
            string arg = "";
            if (HFuseTextBox.Text.Length > 0) {
                arg += "-U hfuse:w:0x" + HFuseTextBox.Text + ":m";
                max += 50;
            }
            if (LFuseTextBox.Text.Length > 0) {
                arg += " -U lfuse:w:0x" + LFuseTextBox.Text + ":m";
                max += 50;
            }
            if (EFuseTextBox.Text.Length > 0) {
                arg += " -U efuse:w:0x" + EFuseTextBox.Text + ":m";
                max += 50;
            }
            ExecCommand(arg, max, false);
        }

        /// <summary>
        /// bNrbgǂݍ݃{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ReadLockBitButton_Click(object sender, EventArgs e) {
            string fname;
            StreamReader sr;
            string data;
            string temp;

            LockBitTextBox.Text = "";

            temp = Environment.GetEnvironmentVariable("temp") + "\\";

            fname = "_lockbit_.txt";
            File.Delete(temp + fname);

            ExecCommand("-U lock:r:" + fname + ":h", 100, false);

            if (File.Exists(temp + fname)) {
                sr = new StreamReader(temp + fname);
                data = sr.ReadLine();
                if (data.Length == 3)
                {
                    LockBitTextBox.Text = "0"+ data.Substring(2, 1).ToUpper();
                }
                else if (data.Length == 4)
                {
                    LockBitTextBox.Text = data.Substring(2, 2).ToUpper();
                }
                sr.Close();
                File.Delete(temp + fname);
            }
        }

        /// <summary>
        /// bNrbg݃{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void WriteLockBitButton_Click(object sender, EventArgs e) {

            Regex reg = new Regex("^[0-9A-Fa-f]{2}$");

            if (LockBitTextBox.Text.Length == 0) {
                MessageBox.Show("Please Set Lock bit.", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                return;
            }
            if (reg.Match(LockBitTextBox.Text).Success == false) {
                MessageBox.Show("Please Set Lock bit by the hexadecimal number of 2 charactors. ",
                    this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                LockBitTextBox.Focus();
                return;
            }

            if (MessageBox.Show("Lock bit is ReWritten. Is it good ?",
                this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2)
                != DialogResult.Yes) return;

            ExecCommand("-U lock:w:0x" + LockBitTextBox.Text + ":m", 150, false);
        }

        /// <summary>
        /// Flash t@CI{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void FlashFileButton_Click(object sender, EventArgs e) {

            OpenFileDialog.CheckFileExists = false;
            OpenFileDialog.AddExtension = true;
            OpenFileDialog.DefaultExt = "hex";
            OpenFileDialog.Filter = "Intel Hex File(*.hex)|*.hex|All File(*.*)|*.*";
            OpenFileDialog.FileName = "";
            OpenFileDialog.ShowDialog();
            if (OpenFileDialog.FileName.Length > 0) {
                FlashFileTextBox.Text = OpenFileDialog.FileName;
            }
        }

        /// <summary>
        /// Flash ǂݍ݃{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ReadFlashButton_Click(object sender, EventArgs e) {

            SaveFileDialog.AddExtension = true;
            SaveFileDialog.DefaultExt = "hex";
            SaveFileDialog.FileName = "";
            SaveFileDialog.Filter = "Hex File (*.hex)|*.hex|All File (*.*)|*.*";
            SaveFileDialog.OverwritePrompt = true;
            SaveFileDialog.Title = "Save Flash data";
            SaveFileDialog.ValidateNames = true;
            if (SaveFileDialog.ShowDialog() == DialogResult.OK) {
                this.Refresh();
                ExecCommand("-U flash:r:\"" + SaveFileDialog.FileName + "\":i", 100, false);
            }
        }

        /// <summary>
        /// Flash ݃{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void WriteFlashButton_Click(object sender, EventArgs e) {

            if (FlashFileTextBox.Text.Length == 0) {
                MessageBox.Show("Select Flash file", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                FlashFileButton.Focus();
                return;
            }
            if (!File.Exists(FlashFileTextBox.Text)) {
                MessageBox.Show("File not found", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                FlashFileButton.Focus();
                return;
            }

            ExecCommand("-D -U flash:w:\"" + FlashFileTextBox.Text + "\":a", 150, false);
        }

        /// <summary>
        /// Flash Verify{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void VerifyFlashButton_Click(object sender, EventArgs e) {

            if (FlashFileTextBox.Text.Length == 0) {
                MessageBox.Show("Select Flash file", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                FlashFileButton.Focus();
                return;
            }
            if (!File.Exists(FlashFileTextBox.Text)) {
                MessageBox.Show("File not found", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                FlashFileButton.Focus();
                return;
            }

            ExecCommand("-U flash:v:\"" + FlashFileTextBox.Text + "\":a", 100, false);
        }

        /// <summary>
        /// Flash Erase - Write - Verify {^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ProgramFlashButton_Click(object sender, EventArgs e) {

            if (FlashFileTextBox.Text.Length == 0) {
                MessageBox.Show("Select Flash file", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                FlashFileButton.Focus();
                return;
            }
            if (!File.Exists(FlashFileTextBox.Text)) {
                MessageBox.Show("File not found", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                FlashFileButton.Focus();
                return;
            }

            ExecCommand("-e -U flash:w:\"" + FlashFileTextBox.Text + "\":a", 150, false);
        }

        /// <summary>
        /// EEPROM t@CI{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void EEPROMFileButton_Click(object sender, EventArgs e) {

            OpenFileDialog.CheckFileExists = false;
            OpenFileDialog.AddExtension = true;
            OpenFileDialog.DefaultExt = "eep";
            OpenFileDialog.Filter = "EEPROM File(*.eep)|*.eep|All File(*.*)|*.*";
            OpenFileDialog.FileName = "";
            OpenFileDialog.ShowDialog();
            if (OpenFileDialog.FileName.Length > 0) {
                EEPROMFileTextBox.Text = OpenFileDialog.FileName;
            }
        }

        /// <summary>
        /// EEPROM ǂݍ݃{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ReadEEPROMButton_Click(object sender, EventArgs e) {

            SaveFileDialog.AddExtension = true;
            SaveFileDialog.DefaultExt = "eep";
            SaveFileDialog.FileName = "";
            SaveFileDialog.Filter = "EEPROM File (*.eep)|*.eep|All File (*.*)|*.*";
            SaveFileDialog.OverwritePrompt = true;
            SaveFileDialog.Title = "Save EEPROM data";
            SaveFileDialog.ValidateNames = true;
            if (SaveFileDialog.ShowDialog() == DialogResult.OK) {
                this.Refresh();
                ExecCommand("-U eeprom:r:\"" + SaveFileDialog.FileName + "\":i", 100, false);
            }
        }

        /// <summary>
        /// EEPROM ݃{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void WriteEEPROMButton_Click(object sender, EventArgs e) {

            if (EEPROMFileTextBox.Text.Length == 0) {
                MessageBox.Show("Select EEPROM file", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                EEPROMFileButton.Focus();
                return;
            }
            if (!File.Exists(EEPROMFileTextBox.Text)) {
                MessageBox.Show("File not found", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                EEPROMFileButton.Focus();
                return;
            }

            ExecCommand("-U eeprom:w:\"" + EEPROMFileTextBox.Text + "\":a", 150, false);
        }

        /// <summary>
        /// I{^
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ExitButton_Click(object sender, EventArgs e) {
            Application.Exit();
        }

        /// <summary>
        /// CtH[RXgN^
        /// </summary>
        public MainForm() {
            InitializeComponent();

            string[] ports;
            ports = SerialPort.GetPortNames();  // LȃVA|[gSĎ擾

            // |[gꗗăR{{bNXɃZbg
            PortComboBox.Items.Add("");     // I
            PortComboBox.Items.Add("avrdoper"); // AVR-Doper
            foreach (string p in ports) {
                if (p.Length > 0) {
                    PortComboBox.Items.Add(p);
                }
            }
            PortComboBox.Items.Add("LPT1");
            PortComboBox.Items.Add("LPT2");
            PortComboBox.Items.Add("USB");
            PortComboBox.Items.Add("usb");      // 2009.1.4 ǉ
            // ɓȃ|[gw肪KvȃvO}ꍇ͒ǉ邱
            PortComboBox.Sorted = true;     //\[g

            // [Uݒ蕜
            AvrdudeTextBox.Text = avrdudeGUI.Default.Avrdude;
            if (AvrdudeTextBox.Text.Length == 0) {
                if (File.Exists("avrdude.exe")) {
                    AvrdudeTextBox.Text = "avrdude.exe";
                }
            }
            if (AvrdudeTextBox.Text.Length > 0) {
                AvrdudeInfo();
            }
            WindowCheckBox.Checked = avrdudeGUI.Default.DisplayWindow;
            CommandLineOptionTextBox.Text = avrdudeGUI.Default.CommandLineOption;

            // ^Cgo[
            this.Text += Application.ProductVersion;
            this.Text = this.Text.Substring(0, this.Text.LastIndexOf('.')); // o[Wԍ폜
            this.Text += "]";
        }

        /// <summary>
        /// Form Closed
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void MainForm_FormClosed(object sender, FormClosedEventArgs e) {

            // [Uݒۑ
            avrdudeGUI.Default.Avrdude = AvrdudeTextBox.Text;
            if (ProgrammerComboBox.SelectedIndex >= 0) {
                avrdudeGUI.Default.Programmer = ProgrammerComboBox.SelectedItem.ToString();
            }
            if (PortComboBox.SelectedIndex >= 0) {
                avrdudeGUI.Default.Port = PortComboBox.SelectedItem.ToString();
            }
            if (DeviceComboBox.SelectedIndex >= 0) {
                avrdudeGUI.Default.Device = DeviceComboBox.SelectedItem.ToString();
            }
            avrdudeGUI.Default.DisplayWindow = WindowCheckBox.Checked;
            avrdudeGUI.Default.CommandLineOption = CommandLineOptionTextBox.Text;
            avrdudeGUI.Default.Save();
        }

        /// <summary>
        /// avrdude.exẽwvo͂vO}EfoCX擾
        /// eR{{bNX̑I
        /// </summary>
        /// <returns></returns>
        private void AvrdudeInfo() {
            int i;
            string line;

            System.Diagnostics.Process prc = avrdude("-c ?");  //  vO}ꗗ
            if (prc == null) return;

            ProgrammerComboBox.Items.Clear();
            while (!prc.StandardError.EndOfStream) {
                Regex reg;
                Match m;

                line = prc.StandardError.ReadLine();
                line = line.Replace('(', '<');          // ()  <> ɒu
                line = line.Replace(')', '>');
                reg = new Regex("(\\w+) += ([^\\[]+)");
                m = reg.Match(line);
                if (m.Success) {
                    ProgrammerComboBox.Items.Add(m.Groups[2].Value.Trim() + " (" + m.Groups[1] + ")");
                }
            }
            prc.WaitForExit();
            if (ProgrammerComboBox.Items.Count > 0) {
                ProgrammerComboBox.Items.Add("AVR-Doper (stk500v2)");   // AVR-Doperǉ
                ProgrammerComboBox.Sorted = true;   // \[g
            }
            for (i = 0; i < ProgrammerComboBox.Items.Count; i++) {
                // ȑO̐ݒƈv̂ΑIԂɂ
                if (ProgrammerComboBox.Items[i].ToString().Equals(avrdudeGUI.Default.Programmer)) {
                    ProgrammerComboBox.SelectedIndex = i;
                    break;
                }
            }

            prc = avrdude("-p ?");  //  foCXꗗ
            if (prc == null) return;

            DeviceComboBox.Items.Clear();
            while (!prc.StandardError.EndOfStream) {
                Regex reg;
                Match m;

                line = prc.StandardError.ReadLine();
                line = line.Replace("TINY", "tiny");    // ǂ킯 TINY tiny݂Ă̂
                line = line.Replace("MEGA", "mega");    // ₷悤
                reg = new Regex("(\\w+) += (\\w+)");
                m = reg.Match(line);
                if (m.Success) {
                    DeviceComboBox.Items.Add(m.Groups[2].Value + " (" + m.Groups[1].Value + ")");
                }
            }
            prc.WaitForExit();
            if (DeviceComboBox.Items.Count > 0) {
                DeviceComboBox.Sorted = true;   // \[g
            }
            for (i = 0; i < DeviceComboBox.Items.Count; i++) {
                if (DeviceComboBox.Items[i].ToString().Equals(avrdudeGUI.Default.Device)) {
                    DeviceComboBox.SelectedIndex = i;
                    break;
                }
            }

            for (i = 0; i < PortComboBox.Items.Count; i++) {
                if (PortComboBox.Items[i].ToString().Equals(avrdudeGUI.Default.Port)) {
                    PortComboBox.SelectedIndex = i;
                    break;
                }
            }
        }


        /// <summary>
        /// avrdude vO}E|[gEfoCXw蕶擾
        /// </summary>
        /// <returns></returns>
        private string GetArg(){
            string prog = "";

            Regex reg = new Regex("\\((\\w+)\\)");  // () ̒̕
            Match m = reg.Match(ProgrammerComboBox.SelectedItem.ToString());
            if (m.Success) {
                prog = m.Groups[1].Value;
            }

            string port = "";
            if (PortComboBox.SelectedIndex >= 0) {
                port = PortComboBox.SelectedItem.ToString();
            }

            string device = "";
            m = reg.Match(DeviceComboBox.SelectedItem.ToString());
            if (m.Success) {
                device = m.Groups[1].Value;
            }

            string arg = " -c " + prog;
            if (port.Length > 0) {
                arg += " -P " + port;
            }
            arg += " -p " + device;

            // {[[gw蓙AR}hC̒ǉp[^ 
            if (CommandLineOptionTextBox.Text.Length > 0) {
                arg += " " + CommandLineOptionTextBox.Text + " ";
            }

            return arg;
        }

        /// <summary>
        /// avrdude.exe sJn
        /// </summary>
        /// <param name="arg">s̈</param>
        /// <returns>ProcessIuWFNg</returns>
        private System.Diagnostics.Process avrdude(string arg) {

            if (AvrdudeTextBox.Text.Length == 0) return null;

            System.Diagnostics.Process prc;
            try {
                System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
                psi.FileName = AvrdudeTextBox.Text;
                psi.RedirectStandardError = true;   // WG[o͂荞
                psi.CreateNoWindow = true;          // EChE\Ȃ
                psi.UseShellExecute = false;        // K{
                psi.Arguments = arg;                // 
                prc = System.Diagnostics.Process.Start(psi);
            } catch {
                prc = null;
            }
            return prc;
        }

        /// <summary>
        /// avrdude R}hs
        /// </summary>
        /// <param name="arg">avrdudë</param>
        /// <param name="maxProgress">avrdudȅo͕񒆂 # ̐(=vOXo[̍ől)</param>
        /// <param name="ignoreError">== true : G[ĂG[_CAO\Ȃ</param>
        /// <returns>avrdude̖߂l</returns>
        private int ExecCommand(string arg, int maxProgress, bool ignoreError) {

            if (AvrdudeTextBox.Text.Length == 0) {
                MessageBox.Show("Select avrdude.exe File", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                AvrdudeButton.Focus();
                return 0;
            }
            if (ProgrammerComboBox.SelectedIndex < 0) {
                MessageBox.Show("Select Programmer", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                ProgrammerComboBox.Focus();
                return 0;
            }
            if (DeviceComboBox.SelectedIndex < 0) {
                MessageBox.Show("Select Device", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                DeviceComboBox.Focus();
                return 0;
            }

            System.Windows.Forms.Cursor cur = System.Windows.Forms.Cursor.Current;

            try {
                System.Windows.Forms.Cursor.Current = Cursors.WaitCursor;   // vJ[\

                System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
                psi.Arguments = "";
                if (WindowCheckBox.Checked == true)
                {
                    // cmd.exe샂[hBG[ɍ̂ŎIȂ
                    psi.FileName = System.Environment.GetEnvironmentVariable("comspec");
                    psi.Arguments = " /K \"" + AvrdudeTextBox.Text + "\" ";
                } else {
                    // ʏ탂[h
                    psi.FileName = AvrdudeTextBox.Text;
                }
                if (WindowCheckBox.Checked == false) {
                    // Window\Ȃ
                    psi.Arguments += GetArg() + " -u " + arg;   // Ĩq[YݒmFȗ
                    psi.CreateNoWindow = true;          // Window\Ȃ
                    psi.RedirectStandardError = true;   // WG[o͂荞
                    psi.UseShellExecute = false;        // K{
                } else {
                    // Windows\(DOSs)
                    psi.Arguments += GetArg() + " " + arg;      // Ĩq[YݒmF͂
                }
                psi.WorkingDirectory = Environment.GetEnvironmentVariable("temp");  // e|
                
                // avrdudeN
                System.Diagnostics.Process prc = System.Diagnostics.Process.Start(psi);

                StringBuilder sb = new StringBuilder();
                if (WindowCheckBox.Checked == false) {
                    ProgressBar.Maximum = maxProgress;
                    ProgressBar.Value = 0;
                    while (!prc.StandardError.EndOfStream) {
                        int c;
                        c = prc.StandardError.Read();
                        // # o͂ꂽvOXo[i߂
                        if ((c == (int)'#') && (ProgressBar.Value < ProgressBar.Maximum)) {
                            ProgressBar.Value += 1;
                        }
                        sb.Append((char)c); // o̓bZ[WƂĂ
                    }
                }
                prc.WaitForExit();  // I҂

                System.Windows.Forms.Cursor.Current = cur;  // J[\߂

                if ((WindowCheckBox.Checked == false) && (prc.ExitCode != 0) && (ignoreError == false)) {
                    // G[̂ŏo̓bZ[W\
                    System.Media.SystemSounds.Asterisk.Play();  // `CH
                    Form md = new ErrorMessageForm();
                    md.Text = this.Text + " Error";
                    md.Controls["MessageTextBox"].Text = sb.ToString();
                    md.ShowDialog();
                    ProgressBar.Value = 0;
                    return 1;
                } else {
                    // I
                    /*
                    MessageBox.Show("avrdude.exe done. Thank you.",
                        this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
                     */
                    ProgressBar.Value = 0;
                    return 0;
                }

            } catch {
                System.Windows.Forms.Cursor.Current = cur;  // J[\߂
                ProgressBar.Value = 0;
                return 1;
            }
        }

    }
}