######################################################################
## Filename:      NDTP.pm
## Version:       
## Description:   library routine for writing NDTP
##                (Network Dictionary Transfer Protocol) client
## Author:        Takahide Higuchi <takahide@hima.gr.jp>
## Created at:    Sat Apr  8 02:43:29 2000
## Modified at:   Thu Apr 27 21:13:14 2000
## Modified by:   Takahide Higuchi <takahide@hima.gr.jp>
## 
## Copyright (c) 1998 Takahide Higuchi <takahide@hima.gr.jp>
## All Rights Reserved.
## 
## This program is free software; you can redistribute it and/or 
## modify it under the terms of the GNU General Public License as 
## published by the Free Software Foundation; either version 2 of 
## the License, or (at your option) any later version.
## 
## I, Takahide Higuchi, provide no warranty for any of this software.
## This material is provided "AS-IS" and at no charge.
## 
######################################################################



package NDTP;
require 'jcode.pl';


sub NDTPauth($$) {
  my($S) = $_[0];
  my($username) = $_[1];
  my $input;
  my $pack = caller;
  $S = $pack . "::" . $S;

  print $S "A".$username."\n";
  chop ($input = <$S>);
  if($input ne '$A')
    {
      return "Authentification failed";
    }
  "";
}


sub close($) {
  my($S) = $_[0];
  my $pack = caller;
  $S = $pack . "::" . $S;

  print $S "Q\n";
  ""; # always succeed
}



sub getDictList ($$)  {
  my ($S) = $_[0];
  my @dicts;
  my $pack = caller;
  $S = $pack . "::" . $S;

  print $S "t\n";
    
  while(1)
    {
      chop($_ = <$S>);

      if( $_ eq '$*' )
	{
	  last;
	}
      
      m/^(\d+)\s+(\S+)\s+(\S+).+/o;
      $dicts[$1] = $2;
      $_[1][$1] = $3;
      $_[1][$1] =~ s|/|_|g;

    }
  @dicts;
}


sub chooseDictionary ($$) {
  my($S) = $_[0];
  my($SelectedDict) = $_[1];
  my $pack = caller;
  $S = $pack . "::" . $S;
  

  print $S "L".$SelectedDict."\n";	

  chop ($input = <$S>);
  if( $input ne '$*' )	
    {
      return "chooseDictionary failed";
    }
  "";
}

sub enableGaijiExtension ($$){
  my ($S, $size) = @_;
  my $pack = caller;
  $S = $pack . "::" . $S;
  
  print $S "XL".$size."\n";
  chop (my $input = <$S>);
  if( $input ne '$*' )
    {
      return ("enableGaijiExtension Failed");
    }
  "";
}

sub getGaijiExtensionInfo ($){
  my $input;

  my($S) = $_[0];
  my $pack = caller;
  $S = $pack . "::" . $S;
  my(@GaijiSize);
  my($Available);

  print $S "XI\n";	

  chop ($input = <$S>);
  if( $input ne '$I' )
    {
      return ("no", "");
    }

  $Available=0;    
  while(1)
    {
      chop ($input = <$S>);
      if( $input eq '$$' )
	{
	  last;
	}

      $GaijiSize[$Available] = $input;
      $Available++;
    }
  ("yes", @GaijiSize);
}



		 
sub getIndexList ($) {
  my $input;

  my($S) = $_[0];
  my $pack = caller;
  $S = $pack . "::" . $S;

  my %index;
  print $S "I\n";

  chop($_ = <$S>);

  if( $_ ne '$I' )
    {
      return "getIndexList failed";
    }
    
  while(1)
    {
      chop($_ = <$S>);
      
      if( $_ eq '$$' )
	{
	  last;
	}
      
      m/^(.+)\s+(.+)/o;
      $index{$1} = $2;   #(index, frame)
    }
  %index;
}


$PatternIndex{'IA'} = "a";
$PatternIndex{'BA'} = "A";
$PatternIndex{'IK'} = "k";
$PatternIndex{'BK'} = "K";


sub getMatchedPattern($$\@\@;$) {

  my ($S,  $query, $wordlist, $framelist, $searchmode) = @_;
  my $pack = caller;
  $S = $pack . "::" . $S;

  my ($hits);

  # -- clear some variables
  @$wordlist = ();
  @$framelist = ();

  jcode::convert(\$query, 'euc', '', 'z');
  
  # -- remove whitespace
  $query =~ tr/ //d;


  # detect searchmode automatically if needed
  if(! defined($PatternIndex{$searchmode}))
    {
      $searchmode = 'IA';


      if(($query =~ /^\Q*\E/g))
	{
	  $searchmode = 'BA';	  
	}
    }

  # --reverse queried string if needed
  if($searchmode =~ /^B./o)
    {
      $query = EucJpReverse($query);
    }
  

  # --if query contains meta character '*' , eliminate it and append one
  if(($query =~ s/\Q*\E$//g))
    {
      $query = $query."*";
    }

 
  print $S "P".$PatternIndex{$searchmode}.$query."\n";

  chop($ans = <$S>);
  if( $ans ne '$0' )	
    {
      return ("getMatchedPattern failed($ans)");
    }
  
  for($hits=0;;$hits++)
    {
      chop(my $word = <$S>);
      
      if( $word eq '$$' )
	{
	  last;
	}
      
      my $frame = <$S>;
      $$framelist[$hits] = $frame;
      $$wordlist[$hits] = $word;
    }
  "";
}

$re_no_euc   = '[\1-\215]|[\218-\240]';
$re_euc_c    = '[\241-\376][\241-\376]';
$re_euc_kana = '\216[\241-\337]';
$re_euc_0212 = '\217[\241-\376][\241-\376]';

sub EucJpReverse($) {
  my($target)= $_[0];
  my($tmp);

  $tmp = $1.$tmp while
    ($target =~ /($re_no_euc|$re_euc_c|$re_euc_kana|$re_euc_0212)/go);

  $tmp;
}




1;  #magic word :x)
