######################################################################
## Filename:      TCPCLIENT.pm
## Version:       
## Description:   common subroutines
## Author:        Takahide Higuchi <thiguchi@pluto.dti.ne.jp>
## Created at:    Sat Apr  8 02:37:17 2000
## Modified at:   Sat Apr  8 03:00:30 2000
## Modified by:   Takahide Higuchi <takahide@hima.gr.jp>
## 
## Copyright (c) 1998 Takahide Higuchi <thiguchi@pluto.dti.ne.jp>
## All Rights Reserved.
## 
## This program is free software; you can redistribute it and/or 
## modify it under the terms of the GNU General Public License as 
## published by the Free Software Foundation; either version 2 of 
## the License, or (at your option) any later version.
## 
## I, Takahide Higuchi, provide no warranty for any of this software.
## This material is provided "AS-IS" and at no charge.
## 
######################################################################


# 
# TCPCLIENT::tcp_client( HANDLE, HOSTNAME, PORT );
#
# it will make HANDLE a valid file handle
#



package TCPCLIENT;
use strict "subs";
use Socket;
use Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(tcp_client);


sub tcp_client ($;$$)
  {
    my ($S, $host ,$port) = @_;
    my $pack = caller;
    $S = $pack . "::" . $S;
    $host = $host || "localhost";
    $port = $port || 2010;
    
    my $proto = getprotobyname('tcp') ;
    socket($S, PF_INET,  SOCK_STREAM, $proto) || 
      return " socket() returned false: resource unavailable";

    $port = getservbyname($port, 'tcp') unless $port =~ /^\d+/;
    $ent = sockaddr_in($port, inet_aton($host));
    connect($S, $ent) || return " connect() returned false: connection failed";
    
    # stop buffering 
    select($S); $| =1; select(STDOUT);
    "";
  }
