######################################################################
## Filename:      forestcommon.pl
## Version:       
## Description:   common subroutines
## Author:        Takahide Higuchi <takahide@hima.gr.jp>
## Created at:    Sat Apr  8 02:44:40 2000
## Modified at:   Sat Apr  8 20:23:21 2000
## Modified by:   Takahide Higuchi <takahide@hima.gr.jp>
## 
## Copyright (c) 1998 Takahide Higuchi <takahide@hima.gr.jp>
## All Rights Reserved.
## 
## This program is free software; you can redistribute it and/or 
## modify it under the terms of the GNU General Public License as 
## published by the Free Software Foundation; either version 2 of 
## the License, or (at your option) any later version.
## 
## I, Takahide Higuchi, provide no warranty for any of this software.
## This material is provided "AS-IS" and at no charge.
## 
######################################################################

require 'forestmsg.pl';

sub check_error($$)  {
  my($S) = $_[0];
  my $pack = caller;
  $S = $pack . "::" . $S;

  if( $_[1] ne '' ) {
    print "Internal Error : ".$_[1]."<br>\n";
    print "Please consult your network administrator.<br>\n";
    errorExit(S,"");
  }
}

sub errorExit($$)  {

  my($S) = $_[0];
  my $pack = caller;
  $S = $pack . "::" . $S;

  print "<h1>Not Found</h1>";
  print "<p>An error occured in the forest.</p>\n";
  print "<p>Check if the query is correct or contact the administrator.</p>";
  # print $S "Q\n";
  print "<p>Error string of the forest is: ";
  print "$_[1]</p><br/>\n";
  print "<hr>";
  print "<address>forest 1.0/NDTP Server at $SERVER_HOST Port http/ndtp</address>";

  $| = 1;
  print "</BODY>\n";
  print "</HTML>\n";
  print "\n";
  $| = 0;
  select(STDOUT);
  exit(0);
}


sub putHTMLHeader($$$) {
  my($S,$title,$mimetype,$charset) = @_;

  print "Content-type: text/html\n";
  print "\n";
  print "<HTML>\n";
  print "<HEAD>\n";
  print "<link rel=\"STYLESHEET\" href=\"/forest/sodan_def.css\" type=\"text/css\">";
  print "<TITLE>$title</TITLE>\n";
  print "<META http-equiv=\"Content-Type\"";
  print " content=\"$mimetype; charset=$charset\">";
  print "</HEAD>\n";
  # print "<BODY BGCOLOR=\"$BGCOLOR\" TEXT=\"$TEXTCOLOR\">\n";
  print "<body>";
}

1; #magic number... weird! :<
