#!/usr/bin/perl


######################################################################
## Filename:      loadgaiji.pl
## Version:       
## Description:   extract exclusive characters (gaiji) from NDTP
##                server into files
## Author:        Takahide Higuchi <takahide@hima.gr.jp>
## Created at:    Sat Apr  8 02:46:02 2000
## Modified at:   Sat Apr  8 02:58:25 2000
## Modified by:   Takahide Higuchi <takahide@hima.gr.jp>
## 
## Copyright (c) 1998 Takahide Higuchi <takahide@hima.gr.jp>
## All Rights Reserved.
## 
## This program is free software; you can redistribute it and/or 
## modify it under the terms of the GNU General Public License as 
## published by the Free Software Foundation; either version 2 of 
## the License, or (at your option) any later version.
## 
## I, Takahide Higuchi, provide no warranty for any of this software.
## This material is provided "AS-IS" and at no charge.
## 
######################################################################





use TCPCLIENT;
use NDTP;

require 'forest.conf';

print "Content-type: image/x-xbitmap\n";
print "\n";

# ----------------- read stdin

if ($ENV{'REQUEST_METHOD'} eq "POST") {
	read(STDIN, $query_string, $ENV{'CONTENT_LENGTH'});
} else {
	$query_string = $ENV{'QUERY_STRING'};
}

# ѿ̾1=1&ѿ̾2=2פη򥢥ѥ( & )ʬ
$i = 0;
@a = split(/&/, $query_string);
foreach $a (@a) {
	# ( = )ʬ
	($name, $value) = split(/=/, $a);
	# +  %8A ʤɤǥ
	$value =~ tr/+/ /;
	$value =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("C", hex($1))/eg;
	# $FORM{'ѿ̾'} 
	$FORM{$name} = $value;	  
    }

# REQUEST
# /cgi-bin/forest/gaiji.pl?dictID=1&GaijiSize=16&xbm=zb124

if(defined($FORM{'dictID'})){
    $dictID = $FORM{'dictID'};  
} else {
    print "dictID\n";
    exit(1);
}

if(defined($FORM{'GaijiSize'})){
    $Size = $FORM{'GaijiSize'};  
} else {
    print "GaijiSize\n";
    exit(1);
}

if(defined($FORM{'xbm'})){
    $xbm = $FORM{'xbm'};  
} else {
    print "xbm\n";
    exit(1);
}

foreach $server (@NDTP_SERVERS) {
    $server =~ /([\w|\Q.\E|\d]+):*(\d+)*/o;
    $NDTP_SERVER = $1;
    if(defined($2)) {
	$NDTP_PORT = $2;
    } else {
    $NDTP_PORT = $DEFAULT_NDTP_PORT;
    }
    
    check_error(S, TCPCLIENT::tcp_client( S,$NDTP_SERVER, $NDTP_PORT));
    check_error(S, NDTP::NDTPauth(S,""));
    check_error(S, NDTP::chooseDictionary(S,$dictID));
    NDTP::enableGaijiExtension(S,$Size);

    loadGaiji(S, $xbm);
}


sub loadGaiji($$)  {
  my($S, $gaijiID) = @_;

  print S "Xb$gaijiID\n";
    chop($line = <S>);
  #print "$line";
    if( $line ne '$I')
    {
	exit (1);
    }
    while(1)
    {
	chop($line = <S>);
	
	print "$line";
	if( $line eq '$$')	  
	{
	    last;
	}
    }
}

sub check_error($$)  {

  my($S) = $_[0];
  my $pack = caller;
  $S = $pack . "::" . $S;

  if( $_[1] ne '' )
    {
      print $S "Q\n";
      print "Internal Error : ".$_[1]."\n";
	
      exit(0);
    }
}
