#!/usr/bin/perl

######################################################################
## Filename:      input.pl
## Version:       
## Description:   output an input form 
## Author:        Takahide Higuchi <takahide@hima.gr.jp>
## Created at:    Sat Apr  8 02:45:34 2000
## Modified at:   Sat Apr  8 21:18:19 2000
## Modified by:   Takahide Higuchi <takahide@hima.gr.jp>
## 
## Copyright (c) 1998 Takahide Higuchi <takahide@hima.gr.jp>
## All Rights Reserved.
## 
## This program is free software; you can redistribute it and/or 
## modify it under the terms of the GNU General Public License as 
## published by the Free Software Foundation; either version 2 of 
## the License, or (at your option) any later version.
## 
## I, Takahide Higuchi, provide no warranty for any of this software.
## This material is provided "AS-IS" and at no charge.
## 
######################################################################






require 'forest.conf';
require 'forestcommon.pl';
require 'forestmsg.pl';


#------------------- program starts here

use TCPCLIENT;
use NDTP;

my $error;

# --- create a  header
putHTMLHeader(STDOUT, 'Forest : Input', 'text/html', $HTML_CHAR_SET,);


#------------------- read stdin 
if ($ENV{'REQUEST_METHOD'} eq "POST") {
	read(STDIN, $query_string, $ENV{'CONTENT_LENGTH'});
} else {
	$query_string = $ENV{'QUERY_STRING'};
}

# ѿ̾1=1&ѿ̾2=2פη򥢥ѥ( & )ʬ
@a = split(/&/, $query_string);
foreach $a (@a) {
	# ( = )ʬ
	($name, $value) = split(/=/, $a);
	# +  %8A ʤɤǥ
	$value =~ tr/+/ /;
	$value =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("C", hex($1))/eg;
	# $FORM{'ѿ̾'} 
	$FORM{$name} = $value;
}

#------------------choose server
if(defined($FORM{'Server'})) {
  $Server=$FORM{'Server'};
} else {
  $Server=0;
}

if(defined($FORM{'GaijiSize'})) {
  $GaijiSize=$FORM{'GaijiSize'};
} else {
  $GaijiSize=$DEFAULT_GAIJI_SIZE;
}
   

$NDTP_SERVERS[$Server] =~ /([\w|\Q.\E|\d|-]+):*(\d+)*/o;
$NDTP_SERVER = $1;
if(defined($2)) {
  $NDTP_PORT = $2;
} else {
  $NDTP_PORT = $DEFAULT_NDTP_PORT;
}


#------------------Connect to NDTP server 
check_error('', TCPCLIENT::tcp_client( S,$NDTP_SERVER, $NDTP_PORT));
check_error(S, NDTP::NDTPauth(S,""));



#------------------get valid dictionaries 

@dictList = NDTP::getDictList(S, *dictIDList);
%indexList = NDTP::getIndexList(S);


# ----------------- create the form

print "<form target=\"content_window\" action=\"$CGI_URI/search.pl\" method=\"GET\">\n";

print "<FONT SIZE=4>$FOREST_MSG{'WORD_FOR_SEARCH'}</FONT><BR>\n";

print "<input type=\"text\" name=\"query\" size=\"$WORD_LENGTH\" ";
print "  maxlength=\"$WORD_LENGTH\" ><br>\n";
print "<input type=\"submit\" value=\"Search\">\n";
print "<input type=\"reset\"><br><br>\n";

# print "<FONT SIZE=4>$FOREST_MSG{'DICTIONARY_FOR_SEARCH'}&nbsp;($FOREST_MSG{'LINKS_REFER_TO_THE_INDEX'})</FONT><br>\n";

  for($i=1; $i < @dictList; $i++) {
    jcode::euc2jis(\$dictList[$i]);

    print "<input type=\"checkbox\" name=\"dictionary\" value=\"$i\"";
    print "CHECKED"; # if ( $i == 1 );
    print ">&nbsp;&nbsp;";
    print "<font size=-4><a target=\"content_window\" href=\"$CGI_URI/viewcontents.pl?dictionary=$i&Server=$Server";
    print "&GaijiSize=$GaijiSize&dictID=$dictIDList[$i]\">";
    print "$dictList[$i]</font></h5><br>\n";
  }


print "<BR>\n";


for($i=1; $i < @dictIDList ; $i++) {
  print "<input type=\"hidden\"  name=\"dictID_$i\"";
  print "  value=\"$dictIDList[$i]\" >\n";
  print "<input type=\"hidden\"  name=\"dictName_$i\"";
  print "  value=\"$dictList[$i]\" >\n";
}

print "<input type=\"hidden\"  name=\"GaijiSize\" value=\"$GaijiSize\" >\n";
print "<input type=\"hidden\"  name=\"Server\" value=\"$Server\" >\n";
print "</form><br>\n";


#-------------------some configurations 

if(@NDTP_SERVERS > 1) {
  print "<FONT SIZE=4>$FOREST_MSG{'NDTP_SERVER_SELECTION'}</FONT><BR>\n<UL>";
  for($i=0; $i<@NDTP_SERVERS; $i++) {
    jcode::euc2jis(\$NDTP_SERVERNAMES[$i]);

    print "<LI><a target=\"input_field\" href=\"$CGI_URI/input.pl?Server=$i\&GaijiSize=$GaijiSize\"";
    print " >";    
    print $NDTP_SERVERNAMES[$i]."</a></LI>\n";
  }
  print "</UL><BR>\n";
}

if(@AVAILABLE_GAIJI_SIZE > 1){
  if( $GaijiSize == 0) {
    print "$FOREST_MSG{'CHANGE_GAIJI_SIZE'}($FOREST_MSG{'CURRENT_SIZE_IS'}";
    print "$FOREST_MSG{'DISABLE_GAIJI'})<br>\n";
  }else {
    print "$FOREST_MSG{'CHANGE_GAIJI_SIZE'}($FOREST_MSG{'CURRENT_SIZE_IS'}";
    print "$GaijiSize)<br>\n";
  }
  for($i=0;$i < @AVAILABLE_GAIJI_SIZE; $i++) {
    if ($AVAILABLE_GAIJI_SIZE[$i] ne $GaijiSize) {
      print "<a href=\"$CGI_URI/input.pl?GaijiSize=$AVAILABLE_GAIJI_SIZE[$i]";
      print "&Server=$Server\" target=\"input_field\">";
      if ($AVAILABLE_GAIJI_SIZE[$i] == 0) {
	print "$FOREST_MSG{'DISABLE_GAIJI'}</a>&nbsp;&nbsp;"
      }else {
	print "$AVAILABLE_GAIJI_SIZE[$i]</a>&nbsp;&nbsp;"
      }
    }
  }
  print "<br><HR>\n";
}



if(%OTHER_DICTIONARIES) {
  print "<BR>$FOREST_MSG{'ANOTHER_DICTIONARIES'}<BR>\n<UL>";
  while(($link,$name) = each %OTHER_DICTIONARIES) {
    jcode::euc2jis(\$name);
    print "<LI><a href=\"$link\" target=\"blank\">$name</a></LI>\n";        
  }    
}





# ***  footer and do fflush()

$| = 1;
print "</BODY>\n";
print "</HTML>\n";
print "\n";
$| = 0;
select(STDOUT);


# close connection;

NDTP::close(S);
exit(0);

