#!/usr/bin/perl


######################################################################
## Filename:      loadgaiji.pl
## Version:       
## Description:   extract exclusive characters (gaiji) from NDTP
##                server into files
## Author:        Takahide Higuchi <takahide@hima.gr.jp>
## Created at:    Sat Apr  8 02:46:02 2000
## Modified at:   Sat Apr  8 02:58:25 2000
## Modified by:   Takahide Higuchi <takahide@hima.gr.jp>
## 
## Copyright (c) 1998 Takahide Higuchi <takahide@hima.gr.jp>
## All Rights Reserved.
## 
## This program is free software; you can redistribute it and/or 
## modify it under the terms of the GNU General Public License as 
## published by the Free Software Foundation; either version 2 of 
## the License, or (at your option) any later version.
## 
## I, Takahide Higuchi, provide no warranty for any of this software.
## This material is provided "AS-IS" and at no charge.
## 
######################################################################





use TCPCLIENT;
use NDTP;

require 'forest.conf';

if($ARGV[0] ne "info" && $ARGV[0] ne "load")
  {
    print "usage: loadgaiji.pl {info|load [fontsize]}\n";
    print "gaiji directory is : $DOC_PATH/\n";
    exit(1);
  } 


foreach $server (@NDTP_SERVERS) {
  $server =~ /([\w|\Q.\E|\d]+):*(\d+)*/o;
  $NDTP_SERVER = $1;
  if(defined($2)) {
    $NDTP_PORT = $2;
  } else {
    $NDTP_PORT = $DEFAULT_NDTP_PORT;
  }


  check_error(S, TCPCLIENT::tcp_client( S,$NDTP_SERVER, $NDTP_PORT));

  print "connecting to $NDTP_SERVER...\n";

  check_error(S, NDTP::NDTPauth(S,""));

  print "authentification done.\n";

  @dictList = NDTP::getDictList(S, *dictIDList);

  for($i=0;$i < @dictList; $i++) {

    # choose dictionary

    check_error(S, NDTP::chooseDictionary(S,$i));
  
    $dictID = $dictIDList[$i];

    ($GaijiExtension, @AvailableGaijiSize)
      = NDTP::getGaijiExtensionInfo(S);

     next if($GaijiExtension ne "yes");

    if($ARGV[0] eq "info") {
      print "  Dictionary  number    : $i\n";
      print "  Dictionary  name      : $dictList[$i]\n";
      print "  Available Gaiji size : ";
      if(@AvailableGaijiSize == 0) {
	print "not available\n\n";
	next;
      }
      for($j=0;$j < @AvailableGaijiSize; $j++) {
	print $AvailableGaijiSize[$j]."  ";
      }
      print "\n\n";
      next;
    }

    for($j=0;$j < @AvailableGaijiSize; $j++) {
      
      $Size   = $AvailableGaijiSize[$j];
      next if(defined($ARGV[1]) && $Size != $ARGV[1]);

    
      NDTP::enableGaijiExtension(S,$Size );
    
      # load all bitmaps if they not exist in local file system

      if (!( -d "$DOC_PATH/$dictID/$Size"))
	{
	  if (!( -d "$DOC_PATH/"))
	    {
	      mkdir("$DOC_PATH/", 0755);
	    }
	  if (!( -d "$DOC_PATH/$dictID"))
	    {
	      mkdir("$DOC_PATH/$dictID", 0755);
	    }
	  if(!( -d "$DOC_PATH/$dictID/$Size"))
	    {
	      mkdir("$DOC_PATH/$dictID/$Size", 0755);
	    }
	  if(!( -d "$DOC_PATH/$dictID/$Size"))
	    {
	      print "Internal Error. failed to mkdir().\n";
	      exit(1);
	    }
	}
      print "Loading gaiji:\n";
      print "  Dictionary  : $dictList[$i]\n";
      print "  Font size   : $Size\n";
      print "  Destination : $DOC_PATH/$dictID/$Size/\n";
      
      loadAllGaijis(S, "$DOC_PATH/$dictID/$Size");
      print "  ... Done.\n";
    }
  }
}


#---------------------------------------


sub loadAllGaijis($$)  {
  my($S, $dir) = @_;
  my $line;
  my $gaijiID;
  my $GAIJIFILE;
  
  print S "XB\n";
  chop($line = <S>);
  if( $line ne '$I')
    {
      return "internal error: loadAllGaijis() failed.(".$line.")\n";
    }

  $gaijiID="";
  while(1)
    {
      chop($line = <S>);

      if( $line eq '$$')	  
	{
	  close(GAIJIFILE);
	  last;
	}

      if($line =~ m/\$\=(.+)/g)
	{
	  if($gaijiID ne "")
	    {
	      close(GAIJIFILE);
	    }

	  $gaijiID = $1;
	  open(GAIJIFILE, '>'.$dir."/".$gaijiID.'.xbm');
	  next;
	};

      print GAIJIFILE $line."\n";
    }
}


#----------------------------------------

sub check_error($$)  {

  my($S) = $_[0];
  my $pack = caller;
  $S = $pack . "::" . $S;

  if( $_[1] ne '' )
    {
      print $S "Q\n";
      print "Internal Error : ".$_[1]."\n";
	
      exit(0);
    }
}
