#!/usr/bin/perl


######################################################################
## Filename:      search.pl
## Version:       
## Description:   search and output a definition of word(s)
## Author:        Takahide Higuchi <takahide@hima.gr.jp>
## Created at:    Sat Apr  8 02:46:23 2000
## Modified at:   Thu Apr 27 21:16:24 2000
## Modified by:   Takahide Higuchi <takahide@hima.gr.jp>
## 
## Copyright (c) 1998 Takahide Higuchi <takahide@hima.gr.jp>
## All Rights Reserved.
## 
## This program is free software; you can redistribute it and/or 
## modify it under the terms of the GNU General Public License as 
## published by the Free Software Foundation; either version 2 of 
## the License, or (at your option) any later version.
## 
## I, Takahide Higuchi, provide no warranty for any of this software.
## This material is provided "AS-IS" and at no charge.
## 
######################################################################




require 'forest.conf';
require 'forestcommon.pl';
require 'forestmsg.pl';
require 'jcode.pl';

use TCPCLIENT;
use NDTP;


# --- create a  header
putHTMLHeader(STDOUT, 'Forest : Search Results', 'text/html', $HTML_CHAR_SET);


# ----------------- read stdin

if ($ENV{'REQUEST_METHOD'} eq "POST") {
	read(STDIN, $query_string, $ENV{'CONTENT_LENGTH'});
} else {
	$query_string = $ENV{'QUERY_STRING'};
}

# ѿ̾1=1&ѿ̾2=2פη򥢥ѥ( & )ʬ
$i = 0;
@a = split(/&/, $query_string);
foreach $a (@a) {
	# ( = )ʬ
	($name, $value) = split(/=/, $a);
	# +  %8A ʤɤǥ
	$value =~ tr/+/ /;
	$value =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("C", hex($1))/eg;
	# $FORM{'ѿ̾'} 

	if ($name eq 'dictionary') {
	  $dictionary[$i++] = $value;
	}else {
	  $FORM{$name} = $value;	  
	}
}

#------------------ error check

$query = $FORM{'query'};
$frame = $FORM{'frame'};
$Server=$FORM{'Server'};
$GaijiSize=$FORM{'GaijiSize'};
$GaijiSize=$DEFAULT_GAIJI_SIZE unless defined($FORM{'GaijiSize'});
$Server=0 unless defined($FORM{'Server'});

if(!defined($frame) && ((!defined($query)||length($query) == 0))) {
  errorExit(S, "ERROR: ".$FOREST_MSG{'QUERY_NOT_GIVEN'});
}



if(@dictionary == 0){
  errorExit(S, "ERROR: ".$FOREST_MSG{'DICTIONARY_IS_NOT_GIVEN'});
}

#------------------choose server
$NDTP_SERVERS[$Server] =~ /([\w|\Q.\E|\d|-]+):*(\d+)*/o;
$NDTP_SERVER = $1;
if(defined($2)) {
  $NDTP_PORT = $2;
} else {
  $NDTP_PORT = $DEFAULT_NDTP_PORT;
}

# ----------------- connect to NDTP server, list and choose dictionary

check_error('', TCPCLIENT::tcp_client( S,$NDTP_SERVER, $NDTP_PORT));

check_error(S, NDTP::NDTPauth(S,""));



$dictionaryCount=0;
foreach $dictionary (@dictionary){

  # choose dictionary

  check_error(NDTP::chooseDictionary(S, $dictionary));

  # --------------------- if $query exists, call getMatchedPatten
  
  if(defined($FORM{'query'})) {
    # ---- if the dictionary does not support the search, skip it
    if( '' ne NDTP::getMatchedPattern(S,$FORM{'query'}, 
				      @wordlist, @framelist,
				      $FORM{'searchmode'})) {
      next;
    }
  }
  else {
    $wordlist[0] = 'dummy';
    $framelist[0] = $FORM{'frame'};
  }
  
  # If no entries, ignore.
  # print  @wordlist."\n";
  if (@wordlist < 1) {
      ;
  }
  else {

  # DictionaryID,DictionaryName
  if(defined($FORM{'dictID'})){
    $DictionaryID = $FORM{'dictID'};  
  } else {
    $DictionaryID = $FORM{'dictID_'.$dictionary};
    $DictionaryName = $FORM{'dictName_'.$dictionary};
    jcode::euc2jis(\$DictionaryName);
  }


  # enable bitmap extension if available
  
  ($GaijiExtension, @AvailableGaijiSize)
    = NDTP::getGaijiExtensionInfo(S);
  
  if( $GaijiExtension eq 'yes' ) {
    $GaijiSizetoUse=$GaijiSize;
    for($i=0;$i<@AvailableGaijiSize;$i++) {
      if ($GaijiSize >= $AvailableGaijiSize[$i] && 
	  $GaijiSizetoUse <= $AvailableGaijiSize[$i]) {
	$GaijiSizetoUse = $AvailableGaijiSize[$i];
      }
    }
    
    NDTP::enableGaijiExtension(S,$GaijiSizetoUse );
  }
  
  # --------------------- start printing
  # print '<HR SIZE=2>';
  print "<br>\n";

  # ---------------------- insert some links
#  unless( $dictionaryCount+1 == @dictionary){
#    print '<div align="right">';
#    print '<a href="#dictionary'.($dictionaryCount+1);
#    print '"> '.$FOREST_MSG{'NEXT_DICTIONARY'}.' </a></div><br>'."\n";
#  }
  print "<table width=\"90%\" summary=\"contents\">\n";
  print "<tr><td width=\"100%\"><div class=\"title_back\">\n";
  if(defined($FORM{'query'})) {
#    print '<a name="dictionary'.$dictionaryCount.'">';
    print "<FONT SIZE=5>[ ".$DictionaryName." ] </a></FONT>\n";
    print  @wordlist." $FOREST_MSG{'N_WORDS_ARE_FOUND'}\n" unless defined($FORM{'frame'});
  }
  print "</td></tr></table>\n\n";
  
  for($i=0;$i<@wordlist;$i++)
    {
      # ---------------------- query $wordlist[$i]; 
  print "<table width=\"90%\" summary=\"contents\"><tr>\n";
  print "<td class=\"menu1\">\n";

  print S 'S'.$framelist[$i]."\n";
      
      chop($line = <S>);
      if( $line ne '$1' )
	{
	  errorExit(S, $FOREST_MSG{'CMD_S_FAILED'});
	}
      
      
      unless (defined($FORM{'frame'})) {
	#print "<a name=\"dict$dictionary"."_word$i\">\n" ;
	  
	# ---------------------- insert a "Next" link
	  
	#print '<div align="right">';
	  
	if( $i+1 == @wordlist) {
	  #print "<a href=\"#dict$dictionary"."_word0\"> Top </a></div><br>\n";
	} else {
	  #print "<a href=\"#dict$dictionary"."_word".($i+1);
	  #print "\"> Next </a></div><br>\n";
	}
    }

      while(1) {
	chop($line = <S>);
	last if($line eq '$$');
	# ---------------------- replace <gaiji:nnnn> into <img src="..">
	if($GaijiExtension eq 'yes') {
	    #$line =~ s\<gaiji:(.+?)>\<img src="$DOC_URI/gaiji/$DictionaryID/$GaijiSize/$1.xbm" align="absmiddle" >\g;
	    $line =~ s\<gaiji:(.+?)>\<img src="$CGI_URI/gaiji.pl?dictID=$dictionary&GaijiSize=$GaijiSize&xbm=$1" align="absmiddle" >\g;
	}
	  
	# ---------------------- replace link tag of NDTP into the one of HTML
	$line =~ s\<([0-9a-fA-F]+:[0-9a-fA-F]+)>\<a href="$CGI_URI/search.pl?frame=$1&dictionary=$dictionary&dictID=$DictionaryID&GaijiSize=$GaijiSize&GaijiExtension=$GaijiExtension&Server=$Server">link</a>\g;
	  
	jcode::euc2jis(\$line);
	print $line.'<br>'."\n";
    }
  print "</td></tr></table>\n";
      # print '<hr>'."\n";
  }

  $dictionaryCount++;
} # If the entries exist.
}

# if there are no entries...
if ($dictionaryCount < 1) {
    print "<h1>Not Found</h1>";
    print "<p>The requested query <em>".$query."</em> was not found on this server.</p>";
    print "<p>Check if the query is correct.</p>";
    print "<hr>";
    print "<address>forest 1.0/NDTP Server at $SERVER_HOST Port http/ndtp</address>";
}

print "</BODY>\n";
print "</HTML>\n\n";

exit(0);
