#!/usr/bin/perl



######################################################################
## Filename:      viewcontents.pl
## Version:       
## Description:   output contents of book 
## Author:        Takahide Higuchi <takahide@hima.gr.jp>
## Created at:    Sat Apr  8 02:47:11 2000
## Modified at:   Sat Apr  8 20:10:57 2000
## Modified by:   Takahide Higuchi <takahide@hima.gr.jp>
## 
## Copyright (c) 1998 Takahide Higuchi <takahide@hima.gr.jp>
## All Rights Reserved.
## 
## This program is free software; you can redistribute it and/or 
## modify it under the terms of the GNU General Public License as 
## published by the Free Software Foundation; either version 2 of 
## the License, or (at your option) any later version.
## 
## I, Takahide Higuchi, provide no warranty for any of this software.
## This material is provided "AS-IS" and at no charge.
## 
######################################################################

require 'forest.conf';
require 'forestcommon.pl';
require 'forestmsg.pl';
require 'jcode.pl';


use TCPCLIENT;
use NDTP;

# --- create a  header
putHTMLHeader(STDOUT, 'contents', 'text/html', $HTML_CHAR_SET);

#------------------- read stdin 


if ($ENV{'REQUEST_METHOD'} eq "POST") {
	read(STDIN, $query_string, $ENV{'CONTENT_LENGTH'});
} else {
	$query_string = $ENV{'QUERY_STRING'};
}

# ѿ̾1=1&ѿ̾2=2פη򥢥ѥ( & )ʬ
@a = split(/&/, $query_string);
foreach $a (@a) {
	# ( = )ʬ
	($name, $value) = split(/=/, $a);
	# +  %8A ʤɤǥ
	$value =~ tr/+/ /;
	$value =~ s/%([0-9a-fA-F][0-9a-fA-F])/pack("C", hex($1))/eg;
	# $FORM{'ѿ̾'} 
	$FORM{$name} = $value;
}


#------------------
$GaijiSize=$FORM{'GaijiSize'};
$GaijiSize=$DEFAULT_GAIJI_SIZE unless defined($FORM{'GaijiSize'});
$DictionaryID=$FORM{'dictID'};


$dictionary=$FORM{'dictionary'};
if (!defined($dictionary))
  {
  errorExit(S, "ERROR: ".$FOREST_MSG{'DICTIONARY_IS_NOT_GIVEN'});
}

#------------------choose server
if(defined($FORM{'Server'})) {
  $Server=$FORM{'Server'};
} else {
  errorExit(S, "ERROR: ".$FOREST_MSG{'SERVER_IS_NOT_GIVEN'});
}
   
$NDTP_SERVERS[$Server] =~ /([\w|\Q.\E|\d|-]+):*(\d+)*/o;
$NDTP_SERVER = $1;
if(defined($2)) {
  $NDTP_PORT = $2;
} else {
  $NDTP_PORT = $DEFAULT_NDTP_PORT;
}

#------------------Connect to NDTP server 
check_error('', TCPCLIENT::tcp_client( S,$NDTP_SERVER, $NDTP_PORT));
check_error(S, NDTP::NDTPauth(S,""));



#------------------choose dictionary

check_error(NDTP::chooseDictionary(S, $dictionary));

#------------------enable bitmap extension if available
  
($GaijiExtension, @AvailableGaijiSize)
  = NDTP::getGaijiExtensionInfo(S);
  
%indexList = NDTP::getIndexList(S);


print "<UL>\n";
while(($mode, $frame) = each %indexList) {
  if(defined($ContentsIndex{$mode})) {
    print "<LI><a href=\"/cgi-bin/forest/search.pl?Server=$Server&dictionary=$dictionary";
    print "&GaijiSize=$GaijiSize&GaijiExtension=$GaijiExtension";
    print "&dictID=$DictionaryID&frame=$frame:0\">";
    print $ContentsIndex{$mode}."</a></LI>\n";
    $found='yes';
  }
}
print "</UL>\n";

unless ($found eq 'yes'){
  print $FOREST_MSG{'NO_CONTENTS_OTHER_THAN_SEARCHING'};
}



# ***  footer and do fflush()

$| = 1;
print "</BODY>\n";
print "</HTML>\n";
print "\n";
$| = 0;
select(STDOUT);


# close connection;

NDTP::close(S);
exit(0);
