// Reverb model declaration
//
// Written by Jezar at Dreampoint, June 2000
// http://www.dreampoint.co.uk
// This code is public domain

#ifndef _revmodel_
#define _revmodel_

#include <stdio.h>
#include "comb.hpp"
#include "allpass.hpp"
#include "tuning.h"

class revmodel
{
public:
  revmodel();
  ~revmodel();
  void  resetfs(int fs);
  void  setDefault();
  void	mute();
  void	processmix(float *inputL, float *inputR, float *outputL, float *outputR, long numsamples, int skip);
  void	processreplace(float *inputL, float *inputR, float *outputL, float *outputR, long numsamples, int skip);
  void	setroomsize(float value);
  float	getroomsize();
  void	setdamp(float value);
  float	getdamp();
  void	setwet(float value);
  float	getwet();
  void	setdry(float value);
  float	getdry();
  void	setwidth(float value);
  float	getwidth();
  void	setmode(float value);
  float	getmode();
  void  printconfig();
private:
  void	update();
  void  allocBuffer(int factor);
  void  freeBuffer();
  void  setBuffer(int factor);
  float	gain;
  float	roomsize,roomsize1;
  float	damp,damp1;
  float	wet,wet1,wet2;
  float	dry;
  float	width;
  float	mode;
  
  // The following are all declared inline 
  // to remove the need for dynamic allocation
  // with its subsequent error-checking messiness
  
  // Comb filters
  comb	combL[numcombs];
  comb	combR[numcombs];
  
  // Allpass filters
  allpass	allpassL[numallpasses];
  allpass	allpassR[numallpasses];
  
  // buffer is valid
  int isBufferValid;

  // Buffers for the combs
  float *	bufcombL1;
  float *	bufcombR1;
  float *	bufcombL2;
  float *	bufcombR2;
  float *	bufcombL3;
  float *	bufcombR3;
  float *	bufcombL4;
  float *	bufcombR4;
  float *	bufcombL5;
  float *	bufcombR5;
  float *	bufcombL6;
  float *	bufcombR6;
  float *	bufcombL7;
  float *	bufcombR7;
  float *	bufcombL8;
  float *	bufcombR8;
  
  // Buffers for the allpasses
  float *	bufallpassL1;
  float *	bufallpassR1;
  float *	bufallpassL2;
  float *	bufallpassR2;
  float *	bufallpassL3;
  float *	bufallpassR3;
  float *	bufallpassL4;
  float *	bufallpassR4;
};

#endif//_revmodel_

//ends
