/************************************************************
NAME
	mixing

SYNTAX
	mixing [effect sound wav file]

EXAMPLE
	% mixing sounds/dora.wav
	% mixing sounds/drum.wav

Copyright 2001 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include <SDL.h>
#include <SDL_mixer.h>

#include <stdlib.h>

#define BACKGROUND_IMAGE "images/bg.bmp"

#define MUSIC_FILE "sounds/chopin_vlase64_1-20s.wav"

#define DEFAULT_SOUND_FILE "sounds/dora.wav"

int main(int argc, char* argv[])
{
	SDL_Surface* screen;
	SDL_Surface* bg;
	Mix_Music* music;
	Mix_Chunk* chunk;
	char* soundFileName = DEFAULT_SOUND_FILE;
	int done = 0;

	/* init sdl */
	if (SDL_Init(SDL_INIT_VIDEO)) return -1;
	atexit(SDL_Quit);
	screen = SDL_SetVideoMode(320, 240, 8, SDL_SWSURFACE);

	/* draw background image */
	bg = SDL_LoadBMP(BACKGROUND_IMAGE);
	if (bg == NULL)
	{
		fprintf(stderr, "Couldn't load %s : %s\n", BACKGROUND_IMAGE, SDL_GetError());
		exit(-1);
	}
	SDL_BlitSurface(bg, NULL, screen, NULL);
	SDL_Flip(screen);

	/* init mixer */
	if (Mix_OpenAudio(44100, AUDIO_S16, 2, 4096)) exit(-1);

	/* load bgm */
	music = Mix_LoadMUS(MUSIC_FILE);
	if (music == NULL)
	{
		fprintf(stderr, "Couldn't load %s : %s\n", MUSIC_FILE, SDL_GetError());
		exit(-1);
	}

	/* load effect sound */
	if (argc > 1) soundFileName = argv[1];
	chunk = Mix_LoadWAV(soundFileName);
	if (chunk == NULL)
	{
		fprintf(stderr, "Couldn't load %s : %s\n", soundFileName, SDL_GetError());
		exit(-1);
	}

	Mix_PlayMusic(music, -1); /* loop music start */

	while (!done)
	{
		SDL_Event event;

		SDL_WaitEvent(&event);
		switch (event.type)
		{
		case SDL_KEYUP :
			if ((event.key.keysym.sym == SDLK_ESCAPE) || 
				(event.key.keysym.sym == SDLK_q))
				done = 1;
			else if (event.key.keysym.sym == SDLK_SPACE)
				Mix_PlayChannel(-1, chunk, 0);  /* play chunk! */
			break;
		case SDL_QUIT :
			done = 1;
			break;
		default:
			break;
		}
	}
	
	return 0;
}
