/************************************************************
NAME
	play-bgm

SYNTAX
	play-bgm [bgm file]

EXAMPLE
    $ play-bgm 
    $ play-bgm sounds/chopin_vlase64_1-20s.wav 
    $ play-bgm sounds/chopin_vlase64_1-20s.mp3 
    $ play-bgm sounds/chopin_vlase64_1-20s.ogg 
    $ play-bgm sounds/chopin_vlase64_1.mid 

Copyright 2001 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include <SDL.h>
#include <SDL_mixer.h>
#include <stdlib.h>
#include <revmodel.hpp>

#define DEFAULT_MUSIC_FILE "sounds/chopin_vlase64_1-20s.wav"

#define WAIT_TIME (10 * 100000)
#define MAXS16 (65536/2)

void float2s16(float * f, short int * s, size_t size)
{
  for(size_t t = 0;t < size;t ++)
    {
      s[t] = (short int)(f[t]*MAXS16);
    }
}

void s162float(float * f, short int * s, size_t size)
{
  for(size_t t = 0;t < size;t ++)
    {
      float p = (float)s[t];
      f[t] = p/MAXS16;
    }
}

revmodel reverbm;

// (*Mix_EffectFunc_t)
void reverb(int chan, void *stream, int len, void *udata)
{
  short int * streamsi = (short int *)stream;
  static int count = 0;
  fprintf(stderr, "\r[%08x] chan=%d len=%08x stream=%08x", count, chan, len, stream);
  count ++;

  // split L and R
  short int *uL = new short int[len/2];
  short int *uR = new short int[len/2];
  for(int t = 0;t < len;t += 2)
    {
      memcpy(&(uL[t/2]),&(streamsi[t+0]),sizeof(short int));
      memcpy(&(uR[t/2]),&(streamsi[t+1]),sizeof(short int));
    }

  // float
  float *fL = new float[len/2];
  float *fR = new float[len/2];
  float *oL = new float[len/2];
  float *oR = new float[len/2];
  s162float(fL,uL,len/2);
  s162float(fR,uR,len/2);
  
  //reverbm.processreplace(fL,fR,oL,oR,len/4,1);
  reverbm.processmix(fL,fR,fL,fR,len/4,1);

  float2s16(fL,uL,len/2);
  float2s16(fR,uR,len/2);
  for(int t = 0;t < len;t += 2)
    {
      memcpy(&(streamsi[t+0]),&(uL[t/2]),sizeof(short int));
      memcpy(&(streamsi[t+1]),&(uR[t/2]),sizeof(short int));
    }
  delete[] uL;
  delete[] uR;
  delete[] fL;
  delete[] fR;
  delete[] oL;
  delete[] oR;
}

int main(int argc, char* argv[])
{
  char* musicFileName;
  Mix_Music* music;
  
  /* init sdl */
  if (SDL_Init(0)) exit(-1);
  atexit(SDL_Quit);
  
  /* init mixer */
  if (Mix_OpenAudio(44100, AUDIO_S16, 2, 4096)) exit(-1);
  
  if (argc > 1) 
    musicFileName = argv[1];
  else
    musicFileName = DEFAULT_MUSIC_FILE;
  
  music = Mix_LoadMUS(musicFileName);
  if (music == NULL)
    {
      fprintf(stderr, "Couldn't load %s : %s\n", musicFileName, SDL_GetError());
    }

  // reverb
  //reverbm.resetfs(44100);
  reverbm.setwet(.4);
  reverbm.setroomsize(0.7);
  reverbm.setdry(0.1);
  reverbm.setdamp(0.5);
  reverbm.setwidth(0.9);
  reverbm.printconfig();

  if(!Mix_RegisterEffect(MIX_CHANNEL_POST, reverb, NULL, NULL)) {
      printf("Mix_RegisterEffect: %s\n", Mix_GetError());
  }
  
  Mix_PlayMusic(music, 1); /* music loop count is 1 */
  
  SDL_Delay(WAIT_TIME);
  
  return 0;
}
