//----------------------------------------------------------------------------------------
// Copyright: See definitions.h for License
//----------------------------------------------------------------------------------------
#include "../definitions.h"
#include "matrix.h"
#include "shapebasics.h"
//----------------------------------------------------------------------------------------
#ifndef __TEXT__
#define __TEXT__
//----------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------
struct GlyphEntry
{
        int glyphIndex;
        float glyphAdvance;
};
//----------------------------------------------------------------------------------------
typedef list<GlyphEntry> GlyphEntryList;
//----------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------
class TextRecord
{
        public:
                TextRecord();
                
                int type;
                int reservedFlags;
                bool hasFont, hasColor, hasXOffset, hasYOffset;
                int fontID;
                RGB colour;
                float xOffset;
                float yOffset;
                float textHeight;
                int glyphCount;
                GlyphEntryList glyphEntryList;  
};
//----------------------------------------------------------------------------------------
typedef list<TextRecord> TextRecordList;
//----------------------------------------------------------------------------------------
//----------------------------------------------------------------------------------------
class Text
{
        public:
                Text();
                
            string ToString();

                int characterID;
                RECT bounds;
                Matrix matrix;
                int glyphBits;
                int advanceBits;
                TextRecordList textRecordList;
};        
//----------------------------------------------------------------------------------------
typedef list<Text> TextList;
//----------------------------------------------------------------------------------------
#endif
//----------------------------------------------------------------------------------------
