// 20 11a 214 30e
//   fa  fa  

#include <stdio.h>
#include <stdlib.h>
#include <cstring>
#include <vector>

typedef unsigned char uchar;

typedef struct{
  long int a;
  long int b;
  long int c;
  long int recordSize;
  long int recordLength;
  long int f;
  long int g;
  long int h;
} ListHeader;

void read(void * mem, int size, FILE * fp)
{
  if(fread(mem, 1, size, fp) != size)
    {
      fprintf(stderr, "ERROR: readSize mismatch!\n");
      exit(-1);
    }
}

void hexDump(uchar * str, int size)
{
  for(int i = 0;i < size; i++)
    fprintf(stdout, "%02x ", str[i]);
}

void old_decodeString(uchar * str, int size)
{
  int i = 0;
  for(i = 0;i < size/4;i ++)
    {
      long int ch =
	str[i*4+0]*0x1000000 +
	str[i*4+1]*0x10000 +
	str[i*4+2]*0x100 +
	str[i*4+3]*0x1 ;
      ch = ~(ch - 0x38322223);
      str[i*4+0] = (ch & 0xff000000) / 0x1000000;
      str[i*4+1] = (ch & 0x00ff0000) / 0x10000;
      str[i*4+2] = (ch & 0x0000ff00) / 0x100;
      str[i*4+3] = (ch & 0x000000ff) / 0x1;
      
      fprintf(stdout, "%c%c%c%c", str[i*4+0], str[i*4+1], str[i*4+2], str[i*4+3]);
    }
  for(int j = 0;j < size%4;j ++)
    {
      fprintf(stdout, "%c", ~str[i*4+j]);
    }
  fprintf(stdout, "\r\n");
}


static void decodeString(uchar * str, int size, int32_t key)
{
  int i = 0;
  for(i = 0;i < size/4;i ++)
    {
      int32_t ch =
	str[i*4+0]*0x1000000 + str[i*4+1]*0x10000 +
	str[i*4+2]*0x100 + str[i*4+3]*0x1 ;
      ch = ~(ch - key);
      str[i*4+0] = (ch & 0xff000000) / 0x1000000;
      str[i*4+1] = (ch & 0x00ff0000) / 0x10000;
      str[i*4+2] = (ch & 0x0000ff00) / 0x100;
      str[i*4+3] = (ch & 0x000000ff) / 0x1;
    }
  for(int j = 0;j < size%4;j ++)
    {
      str[i*4+j] = ~str[i*4+j];
    }
}

int loadString(char * strFile)
{
  FILE * fp = fopen(strFile ,"rb");
  ListHeader header;

  if(fp == NULL)
    return -1;
  fprintf(stderr, "%s\n", strFile);
  int readSize;
  fread(&header, 1, sizeof(header), fp);
  fprintf(stderr, " ==== Header Info ====\n");
  fprintf(stderr, " a = %d\n HasIndexTable = %d\n FirstBlockSize = %d\n",
	  header.a, header.b, header.c);
  fprintf(stderr, " Number of Record = %d\n recordLength = %d\n",
	  header.recordSize, header.recordLength);
  fprintf(stderr, " decoderLength = %d\n extraDecodeString = %d\n h = %d\n",
	  header.f, header.g, header.h);
  fprintf(stderr, " =====================\n");

  if(header.recordLength - header.f - header.g - header.b*8 != 8)
    {
      fprintf(stderr, "ERROR: Unkown format.\r\n");
      exit(-1);
    }
  
  // ---
  uchar * str = new uchar[header.recordLength];
  for(int i = 0;i < header.recordSize;i ++)
    {
      read(str, header.recordLength, fp);
      // Main decode string
      decodeString(str, header.f, 0x38322223);
      fprintf(stdout, "%s", str);
      // Extra decode string
      if(header.g != 0)
	{
	  fprintf(stdout, "\r\nExtraString: ");
	  decodeString(str + header.f, header.g, 0x38322223);
	  fprintf(stdout, "\r\n");
	}
      // read table
      if(header.b == 1)
	{
	  // a = -1, b = 0
	  struct{long int a, b, offset, size;} ctable;
	  memcpy(&ctable, str + header.f + header.g, sizeof(ctable));
	  // fprintf(stdout, "size %d offset %d\r\n", ctable.size, ctable.offset);
	  
	  if(ctable.size != 0)
	    {
	      long int at = ftell(fp);
	      fseek(fp, header.c + ctable.offset, SEEK_SET);
	      fprintf(stdout, "<");
	      for(int i_c = 0;i_c < ctable.size;i_c ++)
		{
		  long int lo;
		  fread(&lo, 1, 4, fp);
		  fprintf(stdout, "%d ", lo);
		}
	      fprintf(stdout, ">\r\n");
	      fseek(fp, at, SEEK_SET);
	    }
	}
    }

  fclose(fp);
  return 0;
}

int main(int argc, char * argv[])
{
  if(argc < 2)
    {
      fprintf(stderr, "Usage: %s lst/*.lst\n", argv[0]);
      return 0;
    }
  if(loadString(argv[1]) != 0)
    return -1;
  return 0;
}
