#include "libtoppanread.hpp"
#define KEY 0x224138b2

/*
  CORPMARK.LST(119)   会社名\t会社名 ExtraString=JPG/jpeg48/*.jpg table=製品群
  
  FORMULA.LST(14068)  JPG/FORMULA/*.jpg
  
  H2KOMOKU.LST(14068) id=%06d table=id
  H_KOMOKU.LST(14068) 一般名List... Table=id
  <<Record(2)>>000003     酸化亜鉛        酸化亜鉛 zinc oxide（JP） 皮膚疾患治療剤 262，264<CR>【基本添付文書】　末はマイラン製薬2006年7月改訂，亜鉛華単
  軟膏はサトウザルベ2007年6月改訂，チンク油はマイラン製薬2008年2月改訂，亜鉛華軟膏はマイラン製薬2008年2月改訂，亜鉛華デンプンはオリエンタル2007年2月改訂
  ，貼付剤はボチシート2008年2月改訂，亜鉛華・豚脂軟膏はウイルソン2005年11月改訂 ExtraString: [] Table<3 >

  I_S_REL.LST(14068) 一般ー＞商標
  <<Record(2)>>000003
  <824 825 826 827 828 829 830 831 832 833 834 836 837 838 839 840 841 842 844 845 846 847 849 850 851 852 853 855 3525 11345 11346 11667 11668 11669 11
  671 11672 11673 11674 11675 11676 11677 11678 11679 11681 11682 12884 12887 17936 17937 17940 17941 17942 17943 17945 17946 17947 17948 17949 17952 17
  953 17954 17955 17956 17958 17959 27440 >

  ALL_TEXT.POS(886284=14068*63)

  I_ALL.LST(32966) 一般用薬ふくめすべて
  <<Record(0)>>■0.1％アクリノール液 大和薬品工業（株）オールジャパンドラッグ（株），（株）阪神局方 液 殺菌消毒薬（特殊絆創膏を含む）／[外皮用薬] アクリノール ExtraString: [1]<2067=一般 >
  I_KOMOKU.LST 製品名（■：一般用薬） 製品欧文名 製造販売会社 発売・販売会社 剤形 規格単位 薬価 規制区分 薬効分類 一般名 一般英名 製品備考 YJコード HOT番号

  [1=IPPAN]
  (0)■0.1％アクリノール液(1)(2)(3)(4)(5)
  (6)大和薬品工業（株）(7)(8)(9)オールジャパンドラッグ（株），（株）阪神局方
  (10)(11)(12)液(13)(14)(15)(16)(17)(18)(19)(20)(21)(22)
  (23)(24)殺菌消毒薬（特殊絆創膏を含む）／[外皮用薬](25)(26)
  (27)アクリノール(28)(29)(30)(31)(32)(33)(34)(35)(36)(37)(38)(39)(40)(41)<2067 >

  [0=IRYOU]
  (0)0.3％ペルカミンエス注脊麻用(1)(2)
  (3)Percamin−S(4)(5)
  (6)ナガセ(7)(8)(9)(10)(11)
  (12)注射液：注射(13)(14)
  (15)0.3％3mL1管(16)(17)
  (18)256.00円／管(19)(20)(21)(22)(23)
  (24)121(25)(26)
  (27)ジブカイン塩酸塩(28)(29)
  (30)dibucaine hydrochloride（JP）(cinchocaine（INN）)(31)(32)(33)(34)(35)
  (36)1213400A1033(37)(38)(39)(40)(41)
  <737 >

  [2=SAKUJO](0)3992001F1190【削除品】ATP錠「ヒシヤマ」
  (1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)(12)(13)(14)(15)(16)(17)(18)(19)(20)(21)(22)(23)(24)(25)(26)(27)(28)(29)(30)(31)
  (32)(33)(34)(35)(36)(37)(38)(39)(40)(41)<14068 >

  T_ALL.LST(32966) 一般用薬ふくめすべて
  <<Record(2)>>■0.1％アクリノール液「ニッコーA」                 日興製薬（株）                  液                                              アクリ
  ノール                                  ExtraString: [1]
  <<Record(4)>>0.3％ペルカミンエス注脊麻用                        ナガセ                  注射液：注射                                            ジブカ
  イン塩酸塩                                     ExtraString: [0]
  T_KOMOKU.LST 製品名 製造販売会社 剤形 規制区分 一般名 添加物
  
  S_ALL.LST(32966) 医療用のみ
  <<Record(4)>>                                                                   0.3％ペルカミンエス注脊麻用                     Percamin−S     
  ナガセ                                          局所麻酔剤                                              注射液：注射            
  0.3％3mL1管                     256.00円／管                    1213400A1033                                                            
  ジブカイン塩酸塩                        dibucaine hydrochloride（JP）(cinchocaine（INN）)               ExtraString: [0]<737 >
  S_KOMOKU.LST
  識別コード 色 割線の有無 製品名 製品欧文名 製造販売会社 発売・販売会社 薬効 規制区分 剤形 規格単位 薬価 YJコード HOT番号 製品備考 一般名 一般英名

  SEIHIN.LST(32966) 医療用のみ
  <<Record(4)>>0.3％ペルカミンエス注脊麻用 Percamin−S ナガセ 121 注射液：注射 0.3％3mL1管 256.00円／管 1213400A1033  ジブカイン塩酸塩
  dibucaine hydrochloride（JP）(cinchocaine（INN）)             
  SEKOMOKU.LST 製品名 製品欧文名 製造販売会社 発売・販売会社 薬効分類 規制区分 剤形 規格単位 薬価 YJコード HOT番号 製品備考 一般名 一般英名

  SE_ORG.LST(32966) 医療用のみ
  <<Record(0)>>000001
  <<Record(4)>>製品名：0.3％ペルカミンエス注脊麻用        製品欧文名：Percamin−S 規制等：-       会社名：ナガセ  剤形：注射液:注射       規格：0.3％3mL
  1管     薬価：256.00円／管      薬効分類：121   薬効分類名：局所麻酔剤  YJコード：1213400A1033  HOT番号：-

  SJKOMOKU.LST 製品名 製品欧文名 規制等 会社名 剤形 規格 薬価 薬効分類 薬効分類名 YJコード HOT番号

  KASSEN.LST 割線  有／無
  KISEI.LST/KISEI2.LST 規制
  TXKOMOKU.LST タイトル＋基本添付文書...
  YAKKO.LST  1　神経系及び感覚器官用医薬品  2　個々の器官系用医薬品  3　代謝性医薬品  4　組織細胞機能用医薬品
  5　生薬及び漢方処方に基づく医薬品　病原生物に対する医薬品  7　治療を主目的としない医薬品  8　麻薬
  YAKKO2.LST
  精神神経用薬  消化器官用薬  循環器・血液用薬  呼吸器官用薬  泌尿生殖器官及び肛門用薬  滋養強壮保健薬用薬  外皮用薬  眼科用薬  耳鼻科用薬  禁煙補助剤（他の薬効群に属さない製剤）
  公衆衛生用薬  一般用体外診断薬  その他（いずれの薬効群にも属さない製剤）
  ZAIKEI.LST
  散剤  錠剤  カプセル  液剤  ゼリー  塗布剤  噴霧剤  貼付剤  その他
  ZAIKEI2.LST
  ...do.
*/

void splitString(char * str, std::vector<std::string> &tmpS)
{
  char* keys[256];
  keys[0] = mystrtok(str, '\x09');
  tmpS.push_back(std::string(keys[0]));
  for(int l9 = 1;l9 < 256;l9 ++)
    {
      keys[l9] = mystrtok(NULL, '\x09');
      if(NULL == keys[l9]) break;
      tmpS.push_back(std::string(keys[l9]));
    }
  
}

CDB_LST H_KOMOKU, I_S_REL, I_ALL, FORMULA, I_KOMOKU, S_ALL, T_ALL;
CDB_HON ALL_TEXT;
MED_DIC DICT;
std::unordered_map<std::string,std::string> IPPAN_EIMEI;

int main(int argc, char * argv[])
{
  if(argc < 11)
    {
      fprintf(stderr, "Usage: %s H_KOMOKU.LST I_S_REL.LST I_ALL.LST FORMULA.LST ALL_TEXT.POS ALL_TEXT.STR MSMED12.TXT I_KOMOKU.LST S_ALL.LST T_ALL.LST > out.html\n", argv[0]);
      return 0;
    }
  if(I_ALL.loadFile(argv[3], KEY) != 0) return -1;
  if(I_KOMOKU.loadFile(argv[8], KEY) != 0) return -1;
  if(S_ALL.loadFile(argv[9], KEY) != 0) return -1;
  if(T_ALL.loadFile(argv[10], KEY) != 0) return -1;
  
  fprintf(stdout, "<html><head><title>JAPIC 2009 DRUGS IN JAPAN</title></head><body>\r\n");
  char * str = new char[2048];
  char * str2 = new char[2048];
  char * str3 = new char[2048];
  char * str4 = new char[2048];
  
  // SHOUHINMEI KENSAKU
  std::vector<std::string> strSP, strSP3, strSP4;
  for(int l = 0;l < I_ALL.getRecordSize();l ++)
    {
      fprintf(stderr, "\r1/2 Record %d", l);
      fprintf(stdout, "\r\n<dl>\r\n");
      strncpy(str,  I_ALL.getMainString(l), 2048);
      strncpy(str3, S_ALL.getMainString(l), 2048);
      strncpy(str4, T_ALL.getMainString(l), 2048);
      
      // 0製品名（■：一般用薬） 1製品欧文名 2製造販売会社 3発売・販売会社 4剤形 5規格単位 6薬価 7規制区分 8薬効分類 9一般名 10一般英名 11製品備考 12YJコード 13HOT番号

      strSP.clear(); splitString(str, strSP);
      strSP3.clear();splitString(str3,strSP3);
      strSP4.clear();splitString(str4,strSP4);
      
      char drugtype = I_ALL.getExtraString(l)[0];
      fprintf(stdout, "<dt id=\"JAPIC2009_SHOUHIN_%d\">%s</dt>\r\n<dd>", l+1, strSP[0].c_str());
      const char * keyname = strSP[0].c_str();
      if(drugtype == '1') keyname += 2; // skip ■ and register
      fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", keyname); // かな
      fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", keyname); // 表記
      fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", keyname); // 条件
      fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", keyname); // クロス      
      if(strlen(strSP[3].c_str()) > 0) // register englishseihimmei
	{
	  fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", strSP[3].c_str()); // かな
	  fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", strSP[3].c_str()); // 表記
	  fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", strSP[3].c_str()); // 条件
	  fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", strSP[3].c_str()); // クロス      
	}
      if(strlen(strSP[36].c_str()) > 0) // register YJ code
	{
	  fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", strSP[36].c_str()); // かな
	  fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", strSP[36].c_str()); // 表記
	  fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", strSP[36].c_str()); // 条件
	  fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", strSP[36].c_str()); // クロス      
	}
      if(strlen(strSP[39].c_str()) > 0) // register HOT code
	{
	  fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", strSP[39].c_str()); // かな
	  fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", strSP[39].c_str()); // 表記
	  fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", strSP[39].c_str()); // 条件
	  fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", strSP[39].c_str()); // クロス      
	}

      // register ippan/ippan eimei
      if(IPPAN_EIMEI.find(strSP[27]) == IPPAN_EIMEI.end())
	{
	  IPPAN_EIMEI[strSP[27]] = strSP[30];
	}
      
      switch(drugtype)
	{
	case '2': // 削除
	  fprintf(stdout, "<p>\x81\xa8\x8d\xed\x8f\x9c\x95\x69</p>\r\n");
	  break;
	case '1': // 一般
	case '0': // 医療
	  fprintf(stdout, "<p><a href=\"#JAPIC2009_IPPAN_%06d_BUNSHO\">[\x81\xa8 %s - \x93\x59\x95\x74\x95\xb6\x8f\x91]</a> "
		  "<a href=\"#JAPIC2009_IPPAN_%06d_SHOUHIN\">[\x81\xa8 %s - \x8f\xa4\x95\x69\x96\xbc]</a>",
		  I_ALL.getExtraTableValue(l,0), strSP[27].c_str(), I_ALL.getExtraTableValue(l,0), strSP[27].c_str());
	  if(strlen(strSP[30].c_str()) > 0)
	    fprintf(stdout, " %s", strSP[30].c_str());
	  fprintf(stdout, "</p>\r\n<p>");
	  if(strlen(strSP[0].c_str()) > 0)
	    fprintf(stdout, "[%s] %s", I_KOMOKU.getMainString(0), strSP[0].c_str());
	  if(strlen(strSP[3].c_str()) > 0)
	      fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(1), strSP[3].c_str());
	  fprintf(stdout, "<br>");
	  if(strlen(strSP[6].c_str()) > 0)
	    fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(2), strSP[6].c_str());
	  if(strlen(strSP[9].c_str()) > 0)
	    fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(3), strSP[9].c_str());
	  fprintf(stdout, "<br>");
	  if(strlen(strSP[12].c_str()) > 0)
	    fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(4), strSP[12].c_str());
	  if(strlen(strSP[15].c_str()) > 0)
	    fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(5), strSP[15].c_str());
	  if(strlen(strSP[18].c_str()) > 0)
	    fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(6), strSP[18].c_str());
	  if(strlen(strSP[21].c_str()) > 0)
	    fprintf(stdout, "[%s] %s", I_KOMOKU.getMainString(7), strSP[21].c_str());
	  if(strlen(strSP[24].c_str()) > 0)
	    fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(8), strSP[24].c_str());
	  fprintf(stdout, "<br>");
	  if(strlen(strSP[36].c_str()) > 0)
	    fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(12), strSP[36].c_str());
	  if(strlen(strSP[39].c_str()) > 0)
	    fprintf(stdout, " [%s] %s", I_KOMOKU.getMainString(13), strSP[39].c_str());
	  if(strlen(strSP[33].c_str()) > 0)
	    fprintf(stdout, " [%s] %s<br>", I_KOMOKU.getMainString(11), strSP[33].c_str());

	  if(strlen(strSP3[0].c_str()) > 0) // SHIIBETSU CODE
	    fprintf(stdout, " [\x8e\xaf\x95\xca\x83\x52\x81\x5b\x83\x68] %s ", strSP3[0].c_str());
	  if(strlen(strSP3[3].c_str()) > 0) // COLOR
	    fprintf(stdout, " [\x90\x46] %s ", strSP3[3].c_str());
	  if(strlen(strSP3[6].c_str()) > 0) // KASSEN
	    fprintf(stdout, " [\x8a\x84\x90\xfc] %s ", strSP3[6].c_str());
	  fprintf(stdout, "<br>");

	  if(strlen(strSP4[15].c_str()) > 0) // TENKA
	    fprintf(stdout, " [\x93\x59\x89\xc1\x95\xa8] %s<br>", strSP4[15].c_str());

	  fprintf(stdout, "<br></p>");
	  break;
	default:
	  break;
	}
      
      fprintf(stdout, "</dd>\r\n</dl>\r\n");
    }

  fprintf(stderr, "Done.\n");

  if(FORMULA.loadFile(argv[4], KEY) != 0) return -1;
  if(DICT.loadFile(argv[7]) != 0) return -1;
  if(H_KOMOKU.loadFile(argv[1], KEY) != 0) return -1;
  if(I_S_REL.loadFile(argv[2], KEY) != 0) return -1;
  if(ALL_TEXT.loadFile(argv[5], argv[6], KEY) != 0) return -1;

  // IPPANMEI
  for(int l = 0;l < H_KOMOKU.getRecordSize();l ++)
    {
      fprintf(stderr, "\r2/2 Record %d", l);

      char *GID, *GNAME, *GST = NULL;
      strncpy(str,  H_KOMOKU.getMainString(l), 2048);
      StrReplace(str, "<CR>", "<br>");
      GID = strtok(str, "\x09");
      GNAME = strtok(NULL, "\x09");
      GST = strtok(NULL, "\x09");
      const char * YOMI = DICT.search(GNAME);
      if(YOMI != NULL)
	{
	  strcpy(str2, YOMI);
	  hiragana2katakana((unsigned char*)str2);
	}
 
      // SHOUHIN     
      fprintf(stdout, "\r\n<dl>\r\n");
      fprintf(stdout, "<dt id=\"JAPIC2009_IPPAN_%s_SHOUHIN\">%s - \x8f\xa4\x95\x69\x96\xbc</dt>\r\n", GID, GNAME);
      fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", GNAME); // かな
      fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", GNAME); // 表記
      fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", GNAME); // 条件
      fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", GNAME); // クロス
      std::unordered_map<std::string,std::string>::iterator anst = IPPAN_EIMEI.find(GNAME);
      if(anst != IPPAN_EIMEI.end())
	{
	  if(strlen(anst->second.c_str()) > 0)
	    {
	      fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", anst->second.c_str()); // かな
	      fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", anst->second.c_str()); // 表記
	      fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", anst->second.c_str()); // 条件
	      fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", anst->second.c_str()); // クロス
	    }
	}
      if(YOMI != NULL)
	{
	  // ひらがな
	  fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", YOMI); // かな
	  fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", YOMI); // 表記
	  fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", YOMI); // 条件
	  fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", YOMI); // クロス
	  // 片假名
	  fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", str2); // かな
	  fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", str2); // 表記
	  fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", str2); // 条件
	  fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", str2); // クロス
	}
      // check record
      if(strcmp(I_S_REL.getMainString(l), GID) != 0) fprintf(stderr, "Record Structure Mismatch!!!\n");
      fprintf(stdout, "<dd><p>%s</p>\r\n", GST);
      fprintf(stdout, "<p><a href=\"#JAPIC2009_IPPAN_%s_BUNSHO\">[\x81\xa8 %s - \x93\x59\x95\x74\x95\xb6\x8f\x91]</a></p>\r\n", GID, GNAME);
      fprintf(stdout, "<p><ul>\r\n");
      for(int l0 = 0;l0 <  I_S_REL.getExtraTableSize(l);l0 ++)
	{
	  fprintf(stdout, "<li><a href=\"#JAPIC2009_SHOUHIN_%d\">\x81\xa8</a>%s</li>\r\n",
		  I_S_REL.getExtraTableValue(l, l0), I_ALL.getMainString(I_S_REL.getExtraTableValue(l, l0)-1));
	}
      fprintf(stdout, "</ul></p><br>\r\n</dd>\r\n</dl>\r\n");


      // TENPU BUNSHO
      fprintf(stdout, "\r\n<dl>\r\n");
      fprintf(stdout, "<dt id=\"JAPIC2009_IPPAN_%s_BUNSHO\">%s - \x93\x59\x95\x74\x95\xb6\x8f\x91</dt>\r\n", GID, GNAME);
      
      fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", GNAME); // かな
      fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", GNAME); // 表記
      fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", GNAME); // 条件
      fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", GNAME); // クロス
      if(anst != IPPAN_EIMEI.end())
	{
	  if(strlen(anst->second.c_str()) > 0)
	    {
	      fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", anst->second.c_str()); // かな
	      fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", anst->second.c_str()); // 表記
	      fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", anst->second.c_str()); // 条件
	      fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", anst->second.c_str()); // クロス
	    }
	}
      if(YOMI != NULL)
	{
	  // ひらがな
	  fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", YOMI); // かな
	  fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", YOMI); // 表記
	  fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", YOMI); // 条件
	  fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", YOMI); // クロス
	  // 片假名
	  fprintf(stdout, "<key type=\"\x82\xa9\x82\xc8\">%s</key>\r\n", str2); // かな
	  fprintf(stdout, "<key type=\"\x95\x5c\x8b\x4c\">%s</key>\r\n", str2); // 表記
	  fprintf(stdout, "<key type=\"\x8f\xf0\x8c\x8f\">%s</key>\r\n", str2); // 条件
	  fprintf(stdout, "<key type=\"\x83\x4e\x83\x8d\x83\x58\">%s</key>\r\n", str2); // クロス
	}
      fprintf(stdout, "<dd><p>%s</p><br>\r\n", GST);
      fprintf(stdout, "<p><a href=\"#JAPIC2009_IPPAN_%s_SHOUHIN\">[\x81\xa8 %s - \x8f\xa4\x95\x69\x96\xbc]</a></p><p>\r\n", GID, GNAME);
      
      for(int l2 = 0;l2 < 63;l2 ++)
	{
	  std::string recStr = ALL_TEXT.getMainString(l*63+l2);
	  std::string outStr = replace_all(recStr, "\x81\xa5", "<br>"); // convert ↓ to <br>
	  if(strlen(recStr.c_str()) > 7 &&l2 != 4) // 4 = name again
	    {
	      fprintf(stdout, "%s<br>\n", outStr.c_str());
	    }
	}
      fprintf(stdout, "</p><p>\r\n");
      
      // formula image
      if(strlen(FORMULA.getMainString(l)) > 0)
	{
	  fprintf(stdout, "<a href=\"JPG/FORMULA/%s\">FORMULA:</a><br>\r\n", FORMULA.getMainString(l), FORMULA.getMainString(l));
	}
      fprintf(stdout, "</p></dd>\r\n");
      fprintf(stdout, "</dl>\r\n");
    }


  delete[] str; delete[] str2;
  fprintf(stdout, "</body></html>\r\n");
  fprintf(stderr, "\nDone.\n");
  return 0;
}
// ■ 0x81 0xa1
