// 20 11a 214 30e
//   fa  fa  

#include <stdio.h>
#include <stdlib.h>
#include <cstring>
#include <string>
#include <vector>

typedef unsigned char uchar;

typedef struct{
  long int a;
  long int b;
  long int c;
  long int recordSize;
  long int recordLength;
  long int f;
  long int g;
  long int h;
} ListHeader;

char *mystrtok(char *szMoto, char c){    
  static int i;
  static char* res;
  static bool b=0;
  
  if(szMoto){
    i=0;
    res = szMoto;
    b=1; 
  }else{
    if(!b)return NULL;
    res+=(i+1);
    i=0;
  }
  
  while(res[i]!=c) {
    if(res[i]=='\0'){
      b=0;
      break;
    }
    i++;
  }
  res[i]='\0';
  return res;
}


std::string replace_all (
		    const std::string & source,
		    const std::string & pattern,
		    const std::string & placement
		    )
{
  std::string result;
  std::string::size_type pos_before = 0;
  std::string::size_type pos = 0;
  std::string::size_type len = pattern.size();
  while ((pos = source.find(pattern, pos)) != std::string::npos) {
    result.append(source, pos_before, pos - pos_before);
    result.append(placement);
    pos += len;
    pos_before = pos;
  }
  result.append(source, pos_before, source.size() - pos_before);
  return result;
}

void read(void * mem, int size, FILE * fp)
{
  if(fread(mem, 1, size, fp) != size)
    {
      fprintf(stderr, "ERROR: readSize mismatch!\n");
      exit(-1);
    }
}

void hexDump(uchar * str, int size)
{
  for(int i = 0;i < size; i++)
    fprintf(stdout, "%02x ", str[i]);
}

static void decodeString(uchar * str, int size)
{
  int i = 0;
  for(i = 0;i < size/4;i ++)
    {
      int32_t ch =
	str[i*4+0]*0x1000000 + str[i*4+1]*0x10000 +
	str[i*4+2]*0x100 + str[i*4+3]*0x1 ;
      ch = ~(ch - 0x224138b2);
      str[i*4+0] = (ch & 0xff000000) / 0x1000000;
      str[i*4+1] = (ch & 0x00ff0000) / 0x10000;
      str[i*4+2] = (ch & 0x0000ff00) / 0x100;
      str[i*4+3] = (ch & 0x000000ff) / 0x1;
    }
  for(int j = 0;j < size%4;j ++)
    {
      str[i*4+j] = ~str[i*4+j];
    }
}

void old_decodeString(uchar * str, int size)
{
  int i = 0;
  for(i = 0;i < size/4;i ++)
    {
      long int ch =
	str[i*4+0]*0x1000000 +
	str[i*4+1]*0x10000 +
	str[i*4+2]*0x100 +
	str[i*4+3]*0x1 ;
      ch = ~(ch - 0x224138b2);
      str[i*4+0] = (ch & 0xff000000) / 0x1000000;
      str[i*4+1] = (ch & 0x00ff0000) / 0x10000;
      str[i*4+2] = (ch & 0x0000ff00) / 0x100;
      str[i*4+3] = (ch & 0x000000ff) / 0x1;
      
      fprintf(stdout, "%c%c%c%c",
	      str[i*4+0], str[i*4+1], str[i*4+2], str[i*4+3]);
    }
  for(int j = 0;j < size%4;j ++)
    {
      fprintf(stdout, "%c", ~str[i*4+j]);
    }
  fprintf(stdout, "\r\n");
}

int loadString(char * strFile)
{
  FILE * fp = fopen(strFile ,"rb");
  ListHeader header;

  if(fp == NULL)
    return -1;
  fprintf(stderr, "%s\n", strFile);
  int readSize;
  fread(&header, 1, sizeof(header), fp);
  fprintf(stderr, " ==== Header Info ====\n");
  fprintf(stderr, " a = %d\n HasIndexTable = %d\n FirstBlockSize = %d\n",
	  header.a, header.b, header.c);
  fprintf(stderr, " Number of Record = %d\n recordLength = %d\n",
	  header.recordSize, header.recordLength);
  fprintf(stderr, " decoderLength = %d\n extraDecodeString = %d\n h = %d\n",
	  header.f, header.g, header.h);
  fprintf(stderr, " =====================\n");

  if(header.recordLength - header.f - header.g - header.b*8 != 8)
    {
      fprintf(stderr, "ERROR: Unkown format.\r\n");
      exit(-1);
    }
  
  // ---
  uchar * str = new uchar[header.recordLength*2];
  char* keys[1024]; char extraS[1024]; char * rets;
  for(int i = 0;i < header.recordSize;i ++)
    {
      fprintf(stderr, "<<Record(%d)>>\r", i);
      read(str, header.recordLength, fp);
      str[header.recordLength] = NULL;
      // Main decode string
      decodeString(str, header.f);

      // Extra decode string
      if(header.g != 0)
	{
	  decodeString(str + header.f, header.g);
	  memcpy(extraS, str + header.f, header.g);
	  extraS[header.g] = NULL;
	  fprintf(stdout, "[%s]", extraS);
	}

      rets = (char*)-1; int l9 = 1;
      keys[0] = mystrtok((char*)str, '\t');
      while(rets != NULL)
	{
	  rets = keys[l9] = mystrtok(NULL, '\t');
	  l9 ++;
	}

      rets = keys[0]; l9 = 0;
      while(rets != NULL)
	{
	  fprintf(stdout, "(%d)%s", l9, rets);
	  l9 ++; rets = keys[l9];
	}

      // read table
      if(header.b == 1)
	{
	  // a = -1, b = 0
	  struct{long int a, b, offset, size;} ctable;
	  memcpy(&ctable, str + header.f + header.g, sizeof(ctable));
	  // fprintf(stdout, "size %d offset %d\r\n", ctable.size, ctable.offset);
	  
	  if(ctable.size != 0)
	    {
	      long int at = ftell(fp);
	      fseek(fp, header.c + ctable.offset, SEEK_SET);
	      fprintf(stdout, "<");
	      for(int i_c = 0;i_c < ctable.size;i_c ++)
		{
		  long int lo;
		  fread(&lo, 1, 4, fp);
		  fprintf(stdout, "%d ", lo);
		}
	      fprintf(stdout, ">\r\n");
	      fseek(fp, at, SEEK_SET);
	    }
	}
      fprintf(stdout, "\n");
    }

  fclose(fp);
  return 0;
}

int main(int argc, char * argv[])
{
  if(argc < 2)
    {
      fprintf(stderr, "Usage: %s lst/*.lst\n", argv[0]);
      return 0;
    }
  if(loadString(argv[1]) != 0)
    return -1;
  return 0;
}
