#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <string>
#include <vector>
#include <stdint.h>

#include <map>
#include <unordered_map>

#ifndef _LIBTOPPAN_HPP
#define _LIBTOPPAN_HPP

static char *mystrtok(char *szMoto,char c){    
  static int i; static char* res; static bool b=0;
  if(szMoto){ i=0; res = szMoto; b=1; }
  else{ if(!b)return NULL; res+=(i+1); i=0; }  
  while(res[i]!=c) { if(res[i]=='\0'){ b=0; break; } i++; }
  res[i]='\0';
  return res;
}

std::string replace_all(const std::string & source, const std::string & pattern, const std::string & placement)
{
  std::string result;
  std::string::size_type pos_before = 0;
  std::string::size_type pos = 0;
  std::string::size_type len = pattern.size();
  while ((pos = source.find(pattern, pos)) != std::string::npos) {
    result.append(source, pos_before, pos - pos_before);
    result.append(placement);
    pos += len;
    pos_before = pos;
  }
  result.append(source, pos_before, source.size() - pos_before);
  return result;
}

static char *StrShift( char *String, size_t nShift )
{
  char *start = String;
  char *stop  = String + strlen( String );
  memmove( start + nShift, start, stop-start+1 );
  return String + nShift;
}

static char *StrReplace( char *String, const char *From, const char *To )
{
  int   nToLen;   // 置換する文字列の長さ
  int   nFromLen; // 検索する文字列の長さ
  int   nShift;
  char *start;    // 検索を開始する位置
  char *stop;     // 文字列 String の終端
  char *p;
  nToLen   = strlen( To );
  nFromLen = strlen( From );
  nShift   = nToLen - nFromLen;
  start    = String;
  stop     = String + strlen( String );
  // 文字列 String の先頭から文字列 From を検索
  while( NULL != ( p = strstr( start, From ) ) )
    {
      // 文字列 To が複写できるようにする
      start = StrShift( p + nFromLen, nShift );
      stop  = stop + nShift;
      // 文字列 To を複写
      memmove( p, To, nToLen );
    }
  return String;
}

static void hiragana2katakana(unsigned char * inout)
{
  for(int i = 0;i < strlen((char*)inout)/2;i ++)
    {
      uint16_t aa = (uint16_t)(inout[i*2+0]) << 8 | (uint16_t)(inout[i*2+1]);
      if(0x829f <= aa&&aa <=0x82dd) // ぁ～み 
	{
	  aa += 0x00a1;
	}
      else if(0x82de <= aa&&aa <=0x82f1) // む～ん
	{
	  aa += 0x00a2;
	}
      inout[i*2+0] = (unsigned char)((aa & 0xff00) >> 8);
      inout[i*2+1] = (unsigned char)(aa & 0x00ff);
    }
}

typedef unsigned char uchar;

class MED_DIC
{
public:
  MED_DIC(){;}
  virtual ~MED_DIC(){;}
  int loadFile(const char * filename)
  {
    FILE * fp = fopen(filename ,"rb");
    if(fp == NULL) return -1;
    fprintf(stderr, "Loading %s...\n", filename);

    char * fline = new char[1024];
    int i = 0;
    while(fgets(fline, 1024, fp))
      {
	fprintf(stderr, "\rRecord %d", i++);
	// store in map
	char * YOMIGANA = strtok(fline, "\t");
	char * TANGOSTR = strtok(NULL,  "\t");
	dict[TANGOSTR] = YOMIGANA;
      }
    fprintf(stderr, "\nDone.\n", filename);
    delete[] fline;
    fclose(fp);
    return 0;
  }
  const char * search(const char * tangostr)
  {
    std::unordered_map<std::string,std::string>::iterator ans;
    ans = dict.find(tangostr);
    if(ans != dict.end())
      {
	return ans->second.c_str();
      }
    return NULL;
  }
protected:
  std::unordered_map<std::string,std::string> dict;
};

static void decodeString(uchar * str, int size, int32_t key)
{
  int i = 0;
  for(i = 0;i < size/4;i ++)
    {
      int32_t ch =
	str[i*4+0]*0x1000000 + str[i*4+1]*0x10000 +
	str[i*4+2]*0x100 + str[i*4+3]*0x1 ;
      ch = ~(ch - key);
      str[i*4+0] = (ch & 0xff000000) / 0x1000000;
      str[i*4+1] = (ch & 0x00ff0000) / 0x10000;
      str[i*4+2] = (ch & 0x0000ff00) / 0x100;
      str[i*4+3] = (ch & 0x000000ff) / 0x1;
    }
  for(int j = 0;j < size%4;j ++)
    {
      str[i*4+j] = ~str[i*4+j];
    }
}

typedef struct{
  int32_t pos; int32_t size;
} PositionRecord;

class CDB_HON
{
public:
  CDB_HON(){;}
  virtual ~CDB_HON(){;}
  int loadFile(const char * filename_pos, const char * filename_str, int32_t key)
  {
    maxLength = 0;
    decodeKey = key;
    fn_str = filename_str;
    FILE * fp = fopen(filename_pos ,"rb");
    if(fp == NULL) return -1;
    fprintf(stderr, "Loading %s...\n", filename_pos);
    while (1)
      {
	PositionRecord record;
	int size = fread(&record, 1, 0x8, fp);
	if (size == 0) break;
	fprintf(stderr, "%08x:%08x\r", record.pos, record.size);
	if(maxLength < record.size) maxLength = record.size;
	positionRecord.push_back(record);
      }
    fprintf(stderr, "\nTotal: %d MaxLength: %d\n", positionRecord.size(), maxLength);
    fclose(fp);
    return 0;
  }

  const long getMaxLength()
  {
    return maxLength;
  }

  const char * getMainString(int record)
  {
    FILE * fp = fopen(fn_str.c_str() ,"rb");
    if(fp == NULL) return NULL;
    if(record >= positionRecord.size()) return NULL;
    if(fseek(fp, positionRecord[record].pos, SEEK_SET) != 0) return NULL;
    uchar * str = new uchar[positionRecord[record].size+1];
    str[positionRecord[record].size] = NULL;
    int readSize = fread(str, 1, positionRecord[record].size, fp);
    decodeString(str, readSize, decodeKey);
    retStr = (const char *)str;
    delete[] str;
    fclose(fp);
    return retStr.c_str();
  }
  
protected:
  std::string retStr;
  std::string fn_str;
  std::vector<PositionRecord> positionRecord;
  int32_t decodeKey;
  long maxLength;
};

typedef struct{
  int32_t a; int32_t hasIndexTable; int32_t firstBlockSize;
  int32_t numberOfRecord; int32_t recordLength;
  int32_t decoderLength; int32_t extraDecodeString; int32_t h;
} ListHeader;

class CDB_LST
{
public:
  CDB_LST(){;}
  virtual ~CDB_LST(){;}
  int loadFile(const char * filename, int32_t key)
  {
    decodeKey = key;
    FILE * fp = fopen(filename ,"rb");
    if(fp == NULL) return -1;
    fread(&this->listHeader, 1, sizeof(this->listHeader), fp);
    if(this->listHeader.recordLength - this->listHeader.decoderLength -
       this->listHeader.extraDecodeString - this->listHeader.hasIndexTable*8 != 8)
    {
      fprintf(stderr, "ERROR: Unknown format: %s\n", filename);
      fclose(fp); return -1;
    }

    fprintf(stderr, "Loading %s...\n", filename);
    mainString.clear(); extraString.clear();
    uchar * str  = new uchar[this->listHeader.recordLength+1];
    uchar * str2 = new uchar[this->listHeader.recordLength+1];
    str[this->listHeader.recordLength] = NULL;
    str2[this->listHeader.decoderLength] = NULL;
    std::vector<int32_t> tmpTable;
    for(int i = 0;i < this->listHeader.numberOfRecord;i ++)
      {
	fprintf(stderr, "\rRecord %d/%d", i+1, this->listHeader.numberOfRecord);
	fread(str, 1, this->listHeader.recordLength, fp);
	// Main decode string
	decodeString(str, this->listHeader.decoderLength, decodeKey);
	memcpy(str2, str, this->listHeader.decoderLength);
	mainString.push_back((const char*)str2);
	// Extra decode string
	if(this->listHeader.extraDecodeString != 0)
	  {
	    decodeString(str + this->listHeader.decoderLength, this->listHeader.extraDecodeString, decodeKey);
	    extraString.push_back((const char*)str + this->listHeader.decoderLength);
	  }
	// read table
	tmpTable.clear();
	if(this->listHeader.hasIndexTable == 1)
	  {
	    // a = -1, b = 0
	    struct{int32_t a, b, offset, size;} ctable;
	    memcpy(&ctable, str + this->listHeader.decoderLength + this->listHeader.extraDecodeString, sizeof(ctable));
	    // fprintf(stdout, "size %d offset %d\r\n", ctable.size, ctable.offset);
	    if(ctable.size != 0)
	      {
		// save current file position
		int32_t at = ftell(fp);
		fseek(fp, this->listHeader.firstBlockSize + ctable.offset, SEEK_SET);
		for(int i_c = 0;i_c < ctable.size;i_c ++)
		  {
		    int32_t lo;
		    fread(&lo, 1, 4, fp);
		    tmpTable.push_back(lo);
		  }
		// recover previous file potision
		fseek(fp, at, SEEK_SET);
	      }
	  }
	extraTable.push_back(tmpTable);
      }
    delete[] str; delete[] str2;
    fprintf(stderr, " Done.\n");
    return 0;
  }
  
  const size_t getRecordSize()
  {
    return mainString.size();
  }
  
  const char * getMainString(int record)
  {
    if(record < mainString.size())
      return mainString[record].c_str();
    else
      return NULL;
  }

  const char * getExtraString(int record)
  {
    if(record < extraString.size())
      return extraString[record].c_str();
    else
      return NULL;
  }

  const size_t getExtraTableSize(int record)
  {
    if(record < extraTable.size())
      return extraTable[record].size();
    else
      return NULL;
  }

  const int32_t getExtraTableValue(int record, int loc)
  {
    if(record < extraTable.size())
      if(loc < extraTable[record].size())
	return extraTable[record][loc];
      else
	return -1;
    else
      return -1;
  }

protected:  
  ListHeader listHeader;
  std::vector< std::string > mainString, extraString;
  std::vector< std::vector< int32_t > >  extraTable;
  int32_t decodeKey;
};

#endif
