#include <stdio.h>
#include <vector>

typedef unsigned char uchar;

typedef struct{
  long int pos;
  long int size;
} PositionRecord;

std::vector<PositionRecord> positionRecord;

int record = 0;

int loadPositionRecord(char * posFile)
{
  FILE * fp = fopen(posFile ,"rb");
  if(fp == NULL)
    return -1;
  fprintf(stderr, "%s\n", posFile);

  int recordSize;
  fread(&recordSize, 1, 0x4, fp);
  fprintf(stderr, "recordSize = %d\n", recordSize);
  record = recordSize;
  
  while (1)
    {
      PositionRecord record;
      int size = fread(&record, 1, 0x8, fp);
      if (size == 0)
	break;
      fprintf(stderr, "pos:%08x size:%08x\r", record.pos, record.size);
      positionRecord.push_back(record);
      if(ftell(fp) >= positionRecord.at(0).pos)
	break;
    }
  fprintf(stderr, "\nTotal: %d\n", positionRecord.size());
  fclose(fp);
  return 0;
}

void decodeString(uchar * str, int size)
{
  if(record == 1) // opening.dat is not coded.
    {
      int i = 0;
      for(i = 0;i < size;i ++)
	{
	  fprintf(stdout, "%c", str[i]);
	}
    }
  else
    {
      int i = 0;
      for(i = 0;i < size/4;i ++)
	{
	  long int ch =
	    str[i*4+0]*0x1000000 +
	    str[i*4+1]*0x10000 +
	    str[i*4+2]*0x100 +
	    str[i*4+3]*0x1 ;
	  ch = (~ch + 0x71131722);
	  str[i*4+0] = (ch & 0xff000000) / 0x1000000;
	  str[i*4+1] = (ch & 0x00ff0000) / 0x10000;
	  str[i*4+2] = (ch & 0x0000ff00) / 0x100;
	  str[i*4+3] = (ch & 0x000000ff) / 0x1;
	  
	  fprintf(stdout, "%c%c%c%c",
		  str[i*4+0], str[i*4+1], str[i*4+2], str[i*4+3]);
	}
      for(int j = 0;j < size%4;j ++)
	{
	  fprintf(stdout, "%c", ~str[i*4+j]);
	}
      fprintf(stdout, "\r\n\r\n");
    }
  return;
}

int loadString(char * strFile)
{
  FILE * fp = fopen(strFile ,"rb");
  if(fp == NULL)
    return -1;
  fprintf(stderr, "%s\n", strFile);
  for(std::vector<PositionRecord>::iterator i = positionRecord.begin();
      i != positionRecord.end();i ++)
    {
      if(fseek(fp, i->pos, SEEK_SET) != 0)
	return -1;
      uchar * str = new uchar[i->size];
      int readSize = fread(str, 1, i->size, fp);
      decodeString(str, readSize);
      delete[] str;
    }
  fprintf(stderr, "\nTotal: %d\n", positionRecord.size());
  fclose(fp);
  return 0;
}

int main(int argc, char * argv[])
{
  if(argc < 2)
    {
      fprintf(stderr, "Usage: %s dtl/all.dat or dtl/opening.dat\n", argv[0]);
      return 0;
    }
  if(loadPositionRecord(argv[1]) != 0)
    return -1;
  if(loadString(argv[1]) != 0)
    return -1;
  return 0;
}
