/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee;

import com.rapplogic.xbee.XBeeConnection;
import com.rapplogic.xbee.api.XBeeException;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class SerialPortConnection
implements XBeeConnection,
SerialPortEventListener {
    private static final Logger log = Logger.getLogger(SerialPortConnection.class);
    private InputStream inputStream;
    private OutputStream outputStream;
    private SerialPort serialPort;

    public void openSerialPort(String port, int baudRate) throws PortInUseException, UnsupportedCommOperationException, TooManyListenersException, IOException, XBeeException {
        this.openSerialPort(port, "XBee", 0, baudRate, 8, 1, 0, 0);
    }

    public void openSerialPort(String port, String appName, int timeout, int baudRate) throws PortInUseException, UnsupportedCommOperationException, TooManyListenersException, IOException, XBeeException {
        this.openSerialPort(port, appName, timeout, baudRate, 8, 1, 0, 0);
    }

    public void openSerialPort(String port, String appName, int timeout, int baudRate, int dataBits, int stopBits, int parity, int flowControl) throws PortInUseException, UnsupportedCommOperationException, TooManyListenersException, IOException, XBeeException {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        CommPortIdentifier portId = null;
        boolean found = false;
        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier)portList.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equals(port)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new XBeeException("Could not find port: " + port);
        }
        this.serialPort = (SerialPort)portId.open(appName, timeout);
        this.serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        this.serialPort.setFlowControlMode(0);
        this.serialPort.notifyOnDataAvailable(true);
        this.serialPort.addEventListener((SerialPortEventListener)this);
        this.inputStream = this.serialPort.getInputStream();
        this.outputStream = new BufferedOutputStream(this.serialPort.getOutputStream());
    }

    @Override
    public void close() throws IOException {
        try {
            this.serialPort.getInputStream().close();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.serialPort.getOutputStream().close();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.serialPort.close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                try {
                    if (this.getInputStream().available() > 0) {
                        try {
                            log.debug((Object)("serialEvent: " + this.serialPort.getInputStream().available() + " bytes available"));
                            SerialPortConnection serialPortConnection = this;
                            synchronized (serialPortConnection) {
                                this.notify();
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Error in handleSerialData method", (Throwable)e);
                        }
                        break;
                    }
                    log.warn((Object)"We were notified of new data but available() is returning 0");
                }
                catch (IOException ex) {
                    log.error((Object)"RXTX error in serialEvent method", (Throwable)ex);
                }
                break;
            }
        }
        log.debug((Object)("Ignoring serial port event type: " + event.getEventType()));
    }
}

