/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class XBeePin {
    private String name;
    private Integer pin;
    private String atCommand;
    private Integer atPin;
    private Capability defaultCapability;
    private String description;
    private List<Capability> capabilities = new ArrayList<Capability>();
    private static final List<XBeePin> zigBeePins = new ArrayList<XBeePin>();
    private static final List<XBeePin> wpanPins;

    public XBeePin(String name, Integer pin, String atCommand, Integer atPin, Capability defaultCapability, String description, Capability ... capabilityArr) {
        this.setName(name);
        this.setPin(pin);
        this.setAtCommand(atCommand);
        this.setAtPin(atPin);
        this.setDefaultCapability(defaultCapability);
        this.setDescription(description);
        if (capabilityArr != null) {
            for (Capability capability : capabilityArr) {
                this.getCapabilities().add(capability);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPin() {
        return this.pin;
    }

    public void setPin(Integer pin) {
        this.pin = pin;
    }

    public String getAtCommand() {
        return this.atCommand;
    }

    public void setAtCommand(String atCommand) {
        this.atCommand = atCommand;
    }

    public Capability getDefaultCapability() {
        return this.defaultCapability;
    }

    public void setDefaultCapability(Capability defaultCapability) {
        this.defaultCapability = defaultCapability;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
    }

    public Integer getAtPin() {
        return this.atPin;
    }

    public void setAtPin(Integer atPin) {
        this.atPin = atPin;
    }

    public static List<XBeePin> getZigBeePins() {
        return zigBeePins;
    }

    public static String printAll(List<XBeePin> pins, String delimiter) {
        StringBuffer sb = new StringBuffer();
        sb.append(delimiter);
        sb.append("*Pin #*");
        sb.append(delimiter);
        sb.append("*AT Command*");
        sb.append(delimiter);
        sb.append("*Description*");
        sb.append(delimiter);
        sb.append("*Default Configuration*");
        sb.append(delimiter);
        sb.append("*Supported Configurations (Value)*");
        sb.append(delimiter);
        sb.append("*Analog I/O Method*");
        sb.append(delimiter);
        sb.append("*Digital I/O Method*");
        sb.append(delimiter);
        for (XBeePin pin : pins) {
            sb.append(System.getProperty("line.separator"));
            sb.append(delimiter);
            sb.append(pin.getPin());
            sb.append(delimiter);
            sb.append(pin.getAtCommand() == null ? "n/a" : pin.getAtCommand());
            sb.append(delimiter);
            sb.append(pin.getDescription());
            sb.append(delimiter);
            sb.append(pin.getDefaultCapability() == null ? "n/a" : pin.getDefaultCapability());
            sb.append(delimiter);
            boolean first = false;
            for (Capability cap : pin.getCapabilities()) {
                if (!first) {
                    first = true;
                } else {
                    sb.append(", ");
                }
                sb.append((Object)((Object)cap) + " (0x" + cap.getValue() + ")");
            }
            sb.append(delimiter);
            if (pin.getCapabilities().contains((Object)Capability.ANALOG_INPUT)) {
                sb.append("getAnalog" + pin.getAtPin() + "()");
            } else {
                sb.append("n/a");
            }
            sb.append(delimiter);
            if (pin.getCapabilities().contains((Object)Capability.DIGITAL_INPUT)) {
                sb.append("isD" + pin.getAtPin() + "On()");
            } else {
                sb.append("n/a");
            }
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static List<XBeePin> getWpanPins() {
        return wpanPins;
    }

    public static void main(String[] args) {
        System.out.println(Capability.printAll("|| "));
        System.out.println("Series 1:");
        System.out.println(XBeePin.printAll(wpanPins, "|| "));
        System.out.println("Series 2:");
        System.out.println(XBeePin.printAll(zigBeePins, "|| "));
    }

    static {
        zigBeePins.add(new XBeePin("PWM0/RSSI/DIO10", 6, "P0", 10, Capability.RSSI_PWM, "PWM Output 0 / RX Signal Strength Indicator / Digital IO", Capability.DISABLED, Capability.RSSI_PWM, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("PWM/DIO11", 7, "P1", 1, Capability.UNMONITORED_INPUT, "Digital I/O 11", Capability.UNMONITORED_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("DIO12", 4, "P2", 2, Capability.UNMONITORED_INPUT, "Digital I/O 12", Capability.UNMONITORED_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("AD0/DIO0/Commissioning Button", 20, "D0", 0, Capability.NODE_ID_ENABLED, "Analog Input 0, Digital IO 0, or Commissioning Button", Capability.DISABLED, Capability.NODE_ID_ENABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("AD1/DIO1", 19, "D1", 1, Capability.DISABLED, "Analog Input 1 or Digital I/O 1", Capability.DISABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("AD2/DIO2", 18, "D2", 2, Capability.DISABLED, "Analog Input 2 or Digital I/O 2", Capability.DISABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("AD3/DIO3", 17, "D3", 3, Capability.DISABLED, "Analog Input 3 or Digital I/O 3", Capability.DISABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("DIO4", 11, "D4", 4, Capability.DISABLED, "Digital I/O 4", Capability.DISABLED, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("Associate/DIO5", 15, "D5", 5, Capability.ASSOC_LED, "Associated Indicator, Digital I/O 5", Capability.DISABLED, Capability.ASSOC_LED, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("CTS/DIO7", 12, "D7", 7, Capability.CTS_FLOW_CTRL, "Clear-to-Send Flow Control or Digital I/O 7", Capability.DISABLED, Capability.CTS_FLOW_CTRL, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH, Capability.RS485_TX_LOW, Capability.RS485_TX_HIGH));
        zigBeePins.add(new XBeePin("RTS/DIO6", 16, "D6", 6, Capability.DISABLED, "Request-to-Send Flow Control, Digital I/O 6", Capability.DISABLED, Capability.RTS_FLOW_CTRL, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        zigBeePins.add(new XBeePin("VCC", 1, null, null, null, "Power Supply", null));
        zigBeePins.add(new XBeePin("DOUT", 2, null, null, null, "UART Data Out", null));
        zigBeePins.add(new XBeePin("DIN", 3, null, null, null, "UART Data In", null));
        zigBeePins.add(new XBeePin("RESET", 5, null, null, null, "Module Reset (reset pulse must be at least 200 ns)", null));
        zigBeePins.add(new XBeePin("[reserved]", 8, null, null, null, "Do not connect", null));
        zigBeePins.add(new XBeePin("DTR/SLEEP_RQ", 9, null, null, null, "Pin Sleep Control Line", null));
        zigBeePins.add(new XBeePin("GND", 10, null, null, null, "Ground", null));
        zigBeePins.add(new XBeePin("ON/SLEEP", 13, null, null, null, "Module Status Indicator", null));
        zigBeePins.add(new XBeePin("VREF", 14, null, null, null, "Not used on this module. For compatibility with other XBee modules, we recommend connecting this pin to a voltage reference if Analog sampling is desired. Otherwise, connect to GND", null));
        Collections.sort(zigBeePins, new PinSorter());
        wpanPins = new ArrayList<XBeePin>();
        wpanPins.add(new XBeePin("DTR/SLEEP_RQ/DI8", 9, "D8", 8, Capability.DISABLED, "Pin Sleep Control Line or Digital Input 8", Capability.DISABLED, Capability.DIGITAL_INPUT));
        wpanPins.add(new XBeePin("CTS/DIO7", 12, "D7", 7, Capability.CTS_FLOW_CTRL, "Clear-to-Send Flow Control or Digital I/O 7", Capability.DISABLED, Capability.CTS_FLOW_CTRL, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        wpanPins.add(new XBeePin("RTS/AD6/DIO6", 16, "D6", 6, Capability.DISABLED, "Request-to-Send Flow Control, Analog Input 6 or Digital I/O 6", Capability.DISABLED, Capability.RTS_FLOW_CTRL, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        wpanPins.add(new XBeePin("Associate/AD5/DIO5", 15, "D5", 5, Capability.ASSOC_LED, "Associated Indicator, Analog Input 5 or Digital I/O 5", Capability.DISABLED, Capability.ASSOC_LED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        wpanPins.add(new XBeePin("AD4/DIO4", 11, "D4", 4, Capability.DISABLED, "Analog Input 4 or Digital I/O 4", Capability.DISABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        wpanPins.add(new XBeePin("AD3/DIO3", 17, "D3", 3, Capability.DISABLED, "Analog Input 3 or Digital I/O 3", Capability.DISABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        wpanPins.add(new XBeePin("AD2/DIO2", 18, "D2", 2, Capability.DISABLED, "Analog Input 2 or Digital I/O 2", Capability.DISABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        wpanPins.add(new XBeePin("AD1/DIO1", 19, "D1", 1, Capability.DISABLED, "Analog Input 1 or Digital I/O 1", Capability.DISABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        wpanPins.add(new XBeePin("AD0/DIO0", 20, "D0", 0, Capability.DISABLED, "Analog Input 0 or Digital I/O 0", Capability.DISABLED, Capability.ANALOG_INPUT, Capability.DIGITAL_INPUT, Capability.DIGITAL_OUTPUT_LOW, Capability.DIGITAL_OUTPUT_HIGH));
        wpanPins.add(new XBeePin("PWM0/RSSI", 6, "P0", null, Capability.RSSI_PWM, "PWM Output 0 / RX Signal Strength Indicator", Capability.DISABLED, Capability.RSSI_PWM, Capability.PWM_OUTPUT));
        wpanPins.add(new XBeePin("PWM1", 7, "P1", null, Capability.DISABLED, "PWM Output 1", Capability.DISABLED, Capability.RSSI_PWM, Capability.PWM_OUTPUT));
        wpanPins.add(new XBeePin("VCC", 1, null, null, null, "Power Supply", null));
        wpanPins.add(new XBeePin("DOUT", 2, null, null, null, "UART Data Out", null));
        wpanPins.add(new XBeePin("DIN/CONFIG", 3, null, null, null, "UART Data In", null));
        wpanPins.add(new XBeePin("DO8", 4, null, null, null, "Digital Output 8 (not supported as of 2/28/09)", null));
        wpanPins.add(new XBeePin("RESET", 5, null, null, null, "Module Reset (reset pulse must be at least 200 ns)", null));
        wpanPins.add(new XBeePin("[reserved]", 8, null, null, null, "Do not connect", null));
        wpanPins.add(new XBeePin("GND", 10, null, null, null, "Ground", null));
        wpanPins.add(new XBeePin("ON/SLEEP", 13, null, null, null, "Module Status Indicator", null));
        wpanPins.add(new XBeePin("VREF", 14, null, null, null, "Voltage Reference for A/D Inputs", null));
        Collections.sort(wpanPins, new PinSorter());
    }

    private static class PinSorter
    implements Comparator {
        private PinSorter() {
        }

        public int compare(Object o1, Object o2) {
            return ((XBeePin)o1).getPin().compareTo(((XBeePin)o2).getPin());
        }
    }

    public static enum Capability {
        DISABLED(0),
        RTS_FLOW_CTRL(1),
        CTS_FLOW_CTRL(1),
        RSSI_PWM(1),
        ASSOC_LED(1),
        ANALOG_INPUT(2),
        PWM_OUTPUT(2),
        DIGITAL_INPUT(3),
        DIGITAL_OUTPUT_LOW(4),
        DIGITAL_OUTPUT_HIGH(5),
        UNMONITORED_INPUT(0),
        NODE_ID_ENABLED(1),
        RS485_TX_LOW(6),
        RS485_TX_HIGH(7);

        private final int value;

        private Capability(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static String printAll(String delimiter) {
            StringBuffer sb = new StringBuffer();
            for (Capability cap : Capability.values()) {
                sb.append(System.getProperty("line.separator"));
                sb.append(delimiter);
                sb.append((Object)cap);
                sb.append(delimiter);
                sb.append("0x" + cap.getValue());
                sb.append(cap.getValue());
                sb.append(delimiter);
            }
            return sb.toString();
        }
    }
}

