/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.util.ByteUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ApiId {
    TX_REQUEST_64(0),
    TX_REQUEST_16(1),
    AT_COMMAND(8),
    AT_COMMAND_QUEUE(9),
    REMOTE_AT_REQUEST(23),
    ZNET_TX_REQUEST(16),
    ZNET_EXPLICIT_TX_REQUEST(17),
    RX_64_RESPONSE(128),
    RX_16_RESPONSE(129),
    RX_64_IO_RESPONSE(130),
    RX_16_IO_RESPONSE(131),
    AT_RESPONSE(136),
    TX_STATUS_RESPONSE(137),
    MODEM_STATUS_RESPONSE(138),
    ZNET_RX_RESPONSE(144),
    ZNET_EXPLICIT_RX_RESPONSE(145),
    ZNET_TX_STATUS_RESPONSE(139),
    REMOTE_AT_RESPONSE(151),
    ZNET_IO_SAMPLE_RESPONSE(146),
    ZNET_IO_NODE_IDENTIFIER_RESPONSE(149),
    UNKNOWN(255),
    ERROR_RESPONSE(-1);

    private static final Map<Integer, ApiId> lookup;
    private final int value;

    public static ApiId get(int value) {
        return lookup.get(value);
    }

    private ApiId(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.name() + " (" + ByteUtils.toBase16(this.getValue()) + ")";
    }

    static {
        lookup = new HashMap<Integer, ApiId>();
        for (ApiId s : EnumSet.allOf(ApiId.class)) {
            lookup.put(s.getValue(), s);
        }
    }
}

