/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.XBeeRequest;
import com.rapplogic.xbee.util.ByteUtils;
import com.rapplogic.xbee.util.IntArrayOutputStream;

public class AtCommand
extends XBeeRequest {
    private String command;
    private int[] value;

    public AtCommand(String command) {
        this(command, null, 1);
    }

    public AtCommand(String command, int value) {
        this(command, new int[]{value}, 1);
    }

    public AtCommand(String command, int[] value) {
        this(command, value, 1);
    }

    public AtCommand(String command, int[] value, int frameId) {
        this.command = command;
        this.value = value;
        this.setFrameId(frameId);
    }

    @Override
    public int[] getFrameData() {
        if (this.command.length() > 2) {
            throw new IllegalArgumentException("Command should be two characters.  Do not include AT prefix");
        }
        IntArrayOutputStream out = new IntArrayOutputStream();
        out.write(this.getApiId().getValue());
        out.write(this.getFrameId());
        out.write(this.command.substring(0, 1).toCharArray()[0]);
        out.write(this.command.substring(1, 2).toCharArray()[0]);
        if (this.value != null) {
            out.write(this.value);
        }
        return out.getIntArray();
    }

    @Override
    public ApiId getApiId() {
        return ApiId.AT_COMMAND;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public int[] getValue() {
        return this.value;
    }

    public void setValue(int[] value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return super.toString() + ",command=" + this.command + ",value=" + (this.value == null ? "null" : ByteUtils.toBase16(this.value));
    }
}

