/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.XBeeFrameIdResponse;
import com.rapplogic.xbee.util.ByteUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class AtCommandResponse
extends XBeeFrameIdResponse {
    private int char1;
    private int char2;
    private Status status;
    private int[] value;

    public int getChar1() {
        return this.char1;
    }

    public void setChar1(int char1) {
        this.char1 = char1;
    }

    public int getChar2() {
        return this.char2;
    }

    public void setChar2(int char2) {
        this.char2 = char2;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isOk() {
        return this.status == Status.OK;
    }

    public int[] getValue() {
        return this.value;
    }

    public void setValue(int[] data) {
        this.value = data;
    }

    public String getCommand() {
        return String.valueOf((char)this.char1) + String.valueOf((char)this.char2);
    }

    @Override
    public void parse(IPacketParser parser) throws IOException {
        this.setFrameId(parser.read("AT Response Frame Id"));
        this.setChar1(parser.read("AT Response Char 1"));
        this.setChar2(parser.read("AT Response Char 2"));
        this.setStatus(Status.get(parser.read("AT Response Status")));
        this.setValue(parser.readRemainingBytes());
    }

    @Override
    public String toString() {
        return "command=" + this.getCommand() + ",status=" + (Object)((Object)this.getStatus()) + ",value=" + (this.value == null ? "null" : ByteUtils.toBase16(this.getValue())) + "," + super.toString();
    }

    public static enum Status {
        OK(0),
        ERROR(1),
        INVALID_COMMAND(2),
        INVALID_PARAMETER(3),
        NO_RESPONSE(4);

        private static final Map<Integer, Status> lookup;
        private final int value;

        public static Status get(int value) {
            return lookup.get(value);
        }

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, Status>();
            for (Status s : EnumSet.allOf(Status.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

