/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.util.ByteUtils;
import org.apache.log4j.Logger;

public class Checksum {
    private static final Logger log = Logger.getLogger(Checksum.class);
    public int checksum = 0;

    public void addByte(int val) {
        this.checksum += val;
    }

    public void compute() {
        this.checksum = 0xFF & this.checksum;
        this.checksum = 255 - this.checksum;
        log.debug((Object)("computed checksum is " + ByteUtils.formatByte(this.checksum)));
    }

    public boolean verify() {
        this.checksum &= 0xFF;
        log.debug((Object)("verify checksum is " + this.checksum));
        return 255 == this.checksum;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public static void main(String[] args) {
        Checksum ck = new Checksum();
        ck.addByte(131);
        ck.addByte(86);
        ck.addByte(120);
        ck.addByte(38);
        ck.addByte(0);
        ck.addByte(1);
        ck.addByte(2);
        ck.addByte(0);
        ck.addByte(3);
        ck.addByte(255);
        ck.addByte(131);
        ck.verify();
        System.out.println("checksum is " + ByteUtils.formatByte(ck.getChecksum()));
    }
}

