/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBeeException;

public class HardwareVersion {
    public static RadioType parse(AtCommandResponse response) throws XBeeException {
        if (!response.getCommand().equals("HV")) {
            throw new IllegalArgumentException("This is only applicable to the HV command");
        }
        if (!response.isOk()) {
            throw new XBeeException("Attempt to query HV parameter failed");
        }
        switch (response.getValue()[0]) {
            case 23: {
                return RadioType.SERIES1;
            }
            case 24: {
                return RadioType.SERIES1_PRO;
            }
            case 25: {
                return RadioType.SERIES2;
            }
            case 26: {
                return RadioType.SERIES2_PRO;
            }
            case 30: {
                return RadioType.SERIES2B_PRO;
            }
        }
        return RadioType.UNKNOWN;
    }

    public static enum RadioType {
        SERIES1("Series 1"),
        SERIES1_PRO("Series 1 Pro"),
        SERIES2("Series 2"),
        SERIES2_PRO("Series 2 Pro"),
        SERIES2B_PRO("Series 2B Pro"),
        UNKNOWN("Unknown");

        private String name;

        private RadioType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

