/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.XBeeConnection;
import com.rapplogic.xbee.api.PacketListener;
import com.rapplogic.xbee.api.PacketParser;
import com.rapplogic.xbee.api.XBeeConfiguration;
import com.rapplogic.xbee.api.XBeePacket;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.util.ByteUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class InputStreamThread
implements Runnable {
    private static final Logger log = Logger.getLogger(InputStreamThread.class);
    private Thread thread;
    private ExecutorService listenerPool;
    private volatile boolean done = false;
    private final XBeeConnection connection;
    private XBeeConfiguration conf;
    private final BlockingQueue<XBeeResponse> responseQueue = new LinkedBlockingQueue<XBeeResponse>();
    private final List<PacketListener> packetListenerList = new LinkedList<PacketListener>();

    public XBeeConnection getXBeeConnection() {
        return this.connection;
    }

    public List<PacketListener> getPacketListenerList() {
        return this.packetListenerList;
    }

    public BlockingQueue<XBeeResponse> getResponseQueue() {
        return this.responseQueue;
    }

    public InputStreamThread(XBeeConnection connection, XBeeConfiguration conf) {
        this.connection = connection;
        this.conf = conf;
        this.listenerPool = Executors.newSingleThreadExecutor();
        this.thread = new Thread(this);
        this.thread.setName("InputStreamThread");
        this.thread.start();
        log.debug((Object)"starting packet parser thread");
    }

    private void addResponse(final XBeeResponse response) throws InterruptedException {
        if (this.conf.getResponseQueueFilter() != null) {
            if (this.conf.getResponseQueueFilter().accept(response)) {
                this.addToResponseQueue(response);
            }
        } else {
            this.addToResponseQueue(response);
        }
        this.listenerPool.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = InputStreamThread.this.packetListenerList;
                synchronized (list) {
                    for (PacketListener pl : InputStreamThread.this.packetListenerList) {
                        try {
                            if (pl != null) {
                                pl.processResponse(response);
                                continue;
                            }
                            log.warn((Object)("PacketListener is null, size is " + InputStreamThread.this.packetListenerList.size()));
                        }
                        catch (Throwable th) {
                            log.warn((Object)"Exception in packet listener", th);
                        }
                    }
                }
            }
        });
    }

    private void addToResponseQueue(XBeeResponse response) throws InterruptedException {
        if (this.conf.getMaxQueueSize() == 0) {
            return;
        }
        while (this.responseQueue.size() >= this.conf.getMaxQueueSize()) {
            log.info((Object)("Response queue has reached the maximum size of " + this.conf.getMaxQueueSize() + " packets.  Trimming a packet from head of queue to make room"));
            this.responseQueue.poll();
        }
        this.responseQueue.put(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block37: {
            int val = -1;
            XBeeResponse response = null;
            PacketParser packetStream = null;
            block28: while (true) {
                try {
                    while (!this.done) {
                        try {
                            if (this.connection.getInputStream().available() > 0) {
                                log.debug((Object)"About to read from input stream");
                                val = this.connection.getInputStream().read();
                                log.debug((Object)("Read " + ByteUtils.formatByte(val) + " from input stream"));
                                if (val == XBeePacket.SpecialByte.START_BYTE.getValue()) {
                                    packetStream = new PacketParser(this.connection.getInputStream());
                                    response = packetStream.parsePacket();
                                    if (log.isInfoEnabled()) {
                                        log.info((Object)("Received packet from XBee: " + response));
                                    }
                                    this.addResponse(response);
                                    continue block28;
                                }
                                log.warn((Object)("expected start byte but got this " + ByteUtils.toBase16(val) + ", discarding"));
                                continue block28;
                            }
                            log.debug((Object)"No data available.. waiting for new data event");
                            XBeeConnection xBeeConnection = this.connection;
                            synchronized (xBeeConnection) {
                                if (this.connection.getInputStream().available() > 0) {
                                    continue;
                                }
                                this.connection.wait();
                                continue block28;
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof InterruptedException) {
                                throw (InterruptedException)e;
                            }
                            log.error((Object)"Error while parsing packet:", (Throwable)e);
                            if (!(e instanceof IOException)) continue;
                            log.error((Object)"Serial device IOException.. exiting");
                            break block37;
                        }
                    }
                    break block37;
                }
                catch (InterruptedException ie) {
                    log.info((Object)"Packet parser thread was interrupted.  This occurs when close() is called");
                    break block37;
                }
                catch (Throwable t) {
                    log.error((Object)"Error in input stream thread.. exiting", t);
                    break block37;
                }
            }
            finally {
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                    if (this.listenerPool != null) {
                        try {
                            this.listenerPool.shutdownNow();
                        }
                        catch (Throwable t) {
                            log.warn((Object)"Failed to shutdown listner thread pool", t);
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Error in input stream thread finally", t);
                }
            }
        }
        log.info((Object)"InputStreamThread is exiting");
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public void interrupt() {
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Exception e) {
                log.warn((Object)"Error interrupting parser thread", (Throwable)e);
            }
        }
    }
}

