/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.NoRequestResponse;
import com.rapplogic.xbee.api.XBeeResponse;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ModemStatusResponse
extends XBeeResponse
implements NoRequestResponse {
    private static final Logger log = Logger.getLogger(ModemStatusResponse.class);
    private Status status;

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    protected void parse(IPacketParser parser) throws IOException {
        int value = parser.read("Modem Status");
        if (value >= 128) {
            this.setStatus(Status.STACK_ERROR);
        } else {
            Status status = Status.get(value);
            if (status == null) {
                log.warn((Object)("Unknown status " + value));
                this.setStatus(Status.UNKNOWN);
            } else {
                this.setStatus(status);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + ",status=" + (Object)((Object)this.status);
    }

    public static enum Status {
        HARDWARE_RESET(0),
        WATCHDOG_TIMER_RESET(1),
        ASSOCIATED(2),
        DISASSOCIATED(3),
        SYNCHRONIZATION_LOST(4),
        COORDINATOR_REALIGNMENT(5),
        COORDINATOR_STARTED(6),
        NETWORK_SEC_KEY_UPDATED(7),
        VOLTAGE_SUPPLY_EXCEEDED(13),
        MODEM_CONFIG_CHANGED(17),
        STACK_ERROR(128),
        UNKNOWN(-1);

        private static final Map<Integer, Status> lookup;
        private final int value;

        public static Status get(int value) {
            return lookup.get(value);
        }

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, Status>();
            for (Status s : EnumSet.allOf(Status.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

