/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.Checksum;
import com.rapplogic.xbee.api.ErrorResponse;
import com.rapplogic.xbee.api.GenericResponse;
import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.ModemStatusResponse;
import com.rapplogic.xbee.api.RemoteAtResponse;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.XBeePacket;
import com.rapplogic.xbee.api.XBeePacketLength;
import com.rapplogic.xbee.api.XBeeParseException;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.wpan.RxResponse16;
import com.rapplogic.xbee.api.wpan.RxResponse64;
import com.rapplogic.xbee.api.wpan.RxResponseIoSample;
import com.rapplogic.xbee.api.wpan.TxStatusResponse;
import com.rapplogic.xbee.api.zigbee.ZNetExplicitRxResponse;
import com.rapplogic.xbee.api.zigbee.ZNetNodeIdentificationResponse;
import com.rapplogic.xbee.api.zigbee.ZNetRxIoSampleResponse;
import com.rapplogic.xbee.api.zigbee.ZNetRxResponse;
import com.rapplogic.xbee.api.zigbee.ZNetTxStatusResponse;
import com.rapplogic.xbee.util.ByteUtils;
import com.rapplogic.xbee.util.IIntInputStream;
import com.rapplogic.xbee.util.InputStreamWrapper;
import com.rapplogic.xbee.util.IntArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PacketParser
implements IIntInputStream,
IPacketParser {
    private static final Logger log = Logger.getLogger(PacketParser.class);
    private IIntInputStream in;
    private XBeePacketLength length;
    private Checksum checksum = new Checksum();
    private boolean done = false;
    private int bytesRead;
    private int escapeBytes;
    private XBeeResponse response;
    private ApiId apiId;
    private int intApiId;
    private static Map<Integer, Class<? extends XBeeResponse>> handlerMap = new HashMap<Integer, Class<? extends XBeeResponse>>();
    private IntArrayOutputStream rawBytes = new IntArrayOutputStream();

    static void registerResponseHandler(int apiId, Class<? extends XBeeResponse> clazz) {
        if (handlerMap.get(apiId) == null) {
            log.info((Object)("Registering response handler " + clazz.getCanonicalName() + " for apiId: " + apiId));
        } else {
            log.warn((Object)("Overriding existing implementation: " + handlerMap.get(apiId).getCanonicalName() + ", with " + clazz.getCanonicalName() + " for apiId: " + apiId));
        }
        handlerMap.put(apiId, clazz);
    }

    static void unRegisterResponseHandler(int apiId) {
        if (handlerMap.get(apiId) == null) {
            throw new IllegalArgumentException("No response handler for: " + apiId);
        }
        log.info((Object)("Unregistering response handler " + handlerMap.get(apiId).getCanonicalName() + " for apiId: " + apiId));
        handlerMap.remove(apiId);
    }

    public PacketParser(InputStream in) {
        this.in = new InputStreamWrapper(in);
    }

    public PacketParser(IIntInputStream in) {
        this.in = in;
    }

    public XBeeResponse parsePacket() {
        Exception exception = null;
        try {
            int msbLength = this.read("Length MSB");
            int lsbLength = this.read("Length LSB");
            this.length = new XBeePacketLength(msbLength, lsbLength);
            log.debug((Object)("packet length is " + String.format("[0x%03X]", this.length.getLength())));
            this.intApiId = this.read("API ID");
            this.apiId = ApiId.get(this.intApiId);
            if (this.apiId == null) {
                this.apiId = ApiId.UNKNOWN;
            }
            log.info((Object)("Handling ApiId: " + (Object)((Object)this.apiId)));
            for (Integer handlerApiId : handlerMap.keySet()) {
                if (this.intApiId != handlerApiId) continue;
                log.debug((Object)("Found response handler for apiId [" + ByteUtils.toBase16(this.intApiId) + "]: " + handlerMap.get(handlerApiId).getCanonicalName()));
                this.response = handlerMap.get(handlerApiId).newInstance();
                this.response.parse(this);
                break;
            }
            if (this.response == null) {
                log.info((Object)("Did not find a response handler for ApiId [" + ByteUtils.toBase16(this.intApiId) + "].  Returning GenericResponse"));
                this.response = new GenericResponse();
                this.response.parse(this);
            }
            this.response.setChecksum(this.read("Checksum"));
            if (!this.isDone()) {
                throw new XBeeParseException("There are remaining bytes according to stated packet length but we have read all the bytes we thought were required for this packet (if that makes sense)");
            }
            this.response.finish();
        }
        catch (Exception e) {
            log.error((Object)("Failed due to exception.  Returning ErrorResponse.  bytes read: " + ByteUtils.toBase16(this.rawBytes.getIntArray())), (Throwable)e);
            exception = e;
            this.response = new ErrorResponse();
            ((ErrorResponse)this.response).setErrorMsg(exception.getMessage());
            ((ErrorResponse)this.response).setException(e);
        }
        if (this.response != null) {
            this.response.setLength(this.length);
            this.response.setApiId(this.apiId);
            this.response.setRawPacketBytes(this.rawBytes.getIntArray());
        }
        return this.response;
    }

    @Override
    public int read(String context) throws IOException {
        int b = this.read();
        log.debug((Object)("Read " + context + " byte, val is " + ByteUtils.formatByte(b)));
        return b;
    }

    private int readFromStream() throws IOException {
        int b = this.in.read();
        this.rawBytes.write(b);
        return b;
    }

    @Override
    public int read() throws IOException {
        if (this.done) {
            throw new XBeeParseException("Packet has read all of its bytes");
        }
        int b = this.readFromStream();
        if (b == -1) {
            throw new XBeeParseException("Read -1 from input stream while reading packet!");
        }
        if (XBeePacket.isSpecialByte(b)) {
            log.debug((Object)"Read special byte that needs to be unescaped");
            if (b == XBeePacket.SpecialByte.ESCAPE.getValue()) {
                log.debug((Object)"found escape byte");
                b = this.readFromStream();
                log.debug((Object)("next byte is " + ByteUtils.formatByte(b)));
                b = 0x20 ^ b;
                log.debug((Object)("unescaped (xor) byte is " + ByteUtils.formatByte(b)));
                ++this.escapeBytes;
            } else {
                log.warn((Object)("Found unescaped special byte " + ByteUtils.formatByte(b) + " at position " + this.bytesRead));
            }
        }
        ++this.bytesRead;
        if (this.bytesRead > 2) {
            this.checksum.addByte(b);
            log.debug((Object)("Read byte " + ByteUtils.formatByte(b) + " at position " + this.bytesRead + ", packet length is " + this.length.get16BitValue() + ", #escapeBytes is " + this.escapeBytes + ", remaining bytes is " + this.getRemainingBytes()));
            if (this.getFrameDataBytesRead() >= this.length.get16BitValue() + 1) {
                this.done = true;
                log.debug((Object)("Checksum byte is " + b));
                if (!this.checksum.verify()) {
                    throw new XBeeParseException("Checksum is incorrect.  Expected 0xff, but got " + this.checksum.getChecksum());
                }
            }
        }
        return b;
    }

    @Override
    public int[] readRemainingBytes() throws IOException {
        int[] value = new int[this.getRemainingBytes() - 1];
        log.debug((Object)("There are " + value.length + " remaining bytes"));
        for (int i = 0; i < value.length; ++i) {
            value[i] = this.read("Remaining bytes " + i);
        }
        return value;
    }

    @Override
    public XBeeAddress64 parseAddress64() throws IOException {
        XBeeAddress64 addr = new XBeeAddress64();
        for (int i = 0; i < 8; ++i) {
            addr.getAddress()[i] = this.read("64-bit Address byte " + i);
        }
        return addr;
    }

    @Override
    public XBeeAddress16 parseAddress16() throws IOException {
        XBeeAddress16 addr16 = new XBeeAddress16();
        addr16.setMsb(this.read("Address 16 MSB"));
        addr16.setLsb(this.read("Address 16 LSB"));
        return addr16;
    }

    @Override
    public int getFrameDataBytesRead() {
        return this.getBytesRead() - 2;
    }

    @Override
    public int getRemainingBytes() {
        return this.length.get16BitValue() - this.getFrameDataBytesRead() + 1;
    }

    @Override
    public int getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(int bytesRead) {
        this.bytesRead = bytesRead;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public int getChecksum() {
        return this.checksum.getChecksum();
    }

    @Override
    public XBeePacketLength getLength() {
        return this.length;
    }

    @Override
    public ApiId getApiId() {
        return this.apiId;
    }

    @Override
    public int getIntApiId() {
        return this.intApiId;
    }

    static {
        handlerMap.put(ApiId.AT_RESPONSE.getValue(), AtCommandResponse.class);
        handlerMap.put(ApiId.MODEM_STATUS_RESPONSE.getValue(), ModemStatusResponse.class);
        handlerMap.put(ApiId.REMOTE_AT_RESPONSE.getValue(), RemoteAtResponse.class);
        handlerMap.put(ApiId.RX_16_IO_RESPONSE.getValue(), RxResponseIoSample.class);
        handlerMap.put(ApiId.RX_64_IO_RESPONSE.getValue(), RxResponseIoSample.class);
        handlerMap.put(ApiId.RX_16_RESPONSE.getValue(), RxResponse16.class);
        handlerMap.put(ApiId.RX_64_RESPONSE.getValue(), RxResponse64.class);
        handlerMap.put(ApiId.TX_STATUS_RESPONSE.getValue(), TxStatusResponse.class);
        handlerMap.put(ApiId.ZNET_EXPLICIT_RX_RESPONSE.getValue(), ZNetExplicitRxResponse.class);
        handlerMap.put(ApiId.ZNET_IO_NODE_IDENTIFIER_RESPONSE.getValue(), ZNetNodeIdentificationResponse.class);
        handlerMap.put(ApiId.ZNET_IO_SAMPLE_RESPONSE.getValue(), ZNetRxIoSampleResponse.class);
        handlerMap.put(ApiId.ZNET_RX_RESPONSE.getValue(), ZNetRxResponse.class);
        handlerMap.put(ApiId.ZNET_TX_STATUS_RESPONSE.getValue(), ZNetTxStatusResponse.class);
    }
}

