/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.util.IntArrayOutputStream;

public class RemoteAtRequest
extends AtCommand {
    private XBeeAddress64 remoteAddr64;
    private XBeeAddress16 remoteAddr16;
    private boolean applyChanges;

    public RemoteAtRequest(int frameId, XBeeAddress64 remoteAddress64, XBeeAddress16 remoteAddress16, boolean applyChanges, String command, int[] value) {
        super(command, value);
        this.setFrameId(frameId);
        this.remoteAddr64 = remoteAddress64;
        this.remoteAddr16 = remoteAddress16;
        this.applyChanges = applyChanges;
    }

    public RemoteAtRequest(int frameId, XBeeAddress64 remoteAddress64, XBeeAddress16 remoteAddress16, boolean applyChanges, String command, int value) {
        this(frameId, remoteAddress64, remoteAddress16, applyChanges, command, new int[]{value});
    }

    public RemoteAtRequest(int frameId, XBeeAddress64 remoteAddress64, XBeeAddress16 remoteAddress16, boolean applyChanges, String command) {
        this(frameId, remoteAddress64, remoteAddress16, applyChanges, command, null);
    }

    public RemoteAtRequest(XBeeAddress64 dest64, String command, int[] value) {
        this(1, dest64, XBeeAddress16.ZNET_BROADCAST, true, command, value);
    }

    public RemoteAtRequest(XBeeAddress64 dest64, String command, int value) {
        this(1, dest64, XBeeAddress16.ZNET_BROADCAST, true, command, new int[]{value});
    }

    public RemoteAtRequest(XBeeAddress64 dest64, String command) {
        this(dest64, command, null);
        this.setApplyChanges(false);
    }

    public RemoteAtRequest(XBeeAddress16 dest16, String command) {
        this(dest16, command, null);
        this.setApplyChanges(false);
    }

    public RemoteAtRequest(XBeeAddress16 remoteAddress16, String command, int[] value) {
        this(1, XBeeAddress64.BROADCAST, remoteAddress16, true, command, value);
    }

    public RemoteAtRequest(XBeeAddress16 remoteAddress16, String command, int value) {
        this(1, XBeeAddress64.BROADCAST, remoteAddress16, true, command, new int[]{value});
    }

    @Override
    public int[] getFrameData() {
        IntArrayOutputStream out = new IntArrayOutputStream();
        out.write(this.getApiId().getValue());
        out.write(this.getFrameId());
        out.write(this.remoteAddr64.getAddress());
        out.write(this.remoteAddr16.getAddress());
        if (this.applyChanges) {
            out.write(2);
        } else {
            out.write(0);
        }
        out.write(this.getCommand().substring(0, 1).toCharArray()[0]);
        out.write(this.getCommand().substring(1, 2).toCharArray()[0]);
        if (this.getValue() != null) {
            out.write(this.getValue());
        }
        return out.getIntArray();
    }

    @Override
    public ApiId getApiId() {
        return ApiId.REMOTE_AT_REQUEST;
    }

    public XBeeAddress64 getRemoteAddr64() {
        return this.remoteAddr64;
    }

    public void setRemoteAddr64(XBeeAddress64 remoteAddr64) {
        this.remoteAddr64 = remoteAddr64;
    }

    public XBeeAddress16 getRemoteAddr16() {
        return this.remoteAddr16;
    }

    public void setRemoteAddr16(XBeeAddress16 remoteAddr16) {
        this.remoteAddr16 = remoteAddr16;
    }

    public boolean isApplyChanges() {
        return this.applyChanges;
    }

    public void setApplyChanges(boolean applyChanges) {
        this.applyChanges = applyChanges;
    }

    @Override
    public String toString() {
        return super.toString() + ",remoteAddr64=" + this.remoteAddr64 + ",remoteAddr16=" + this.remoteAddr16 + ",applyChanges=" + this.applyChanges;
    }
}

