/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import java.io.IOException;

public class RemoteAtResponse
extends AtCommandResponse {
    private XBeeAddress64 remoteAddress64;
    private XBeeAddress16 remoteAddress16;

    public boolean isSixteenBitAddressUnknown() {
        return this.remoteAddress16.getMsb() == 255 && this.remoteAddress16.getLsb() == 254;
    }

    public XBeeAddress64 getRemoteAddress64() {
        return this.remoteAddress64;
    }

    public void setRemoteAddress64(XBeeAddress64 sixtyFourBitResponderAddress) {
        this.remoteAddress64 = sixtyFourBitResponderAddress;
    }

    public XBeeAddress16 getRemoteAddress16() {
        return this.remoteAddress16;
    }

    public void setRemoteAddress16(XBeeAddress16 sixteenBitResponderAddress) {
        this.remoteAddress16 = sixteenBitResponderAddress;
    }

    public String getCommandName() {
        return super.getCommand();
    }

    public int[] getCommandData() {
        return super.getValue();
    }

    @Override
    public void parse(IPacketParser parser) throws IOException {
        this.setFrameId(parser.read("Remote AT Response Frame Id"));
        this.setRemoteAddress64(parser.parseAddress64());
        this.setRemoteAddress16(parser.parseAddress16());
        char cmd1 = (char)parser.read("Command char 1");
        char cmd2 = (char)parser.read("Command char 2");
        this.setChar1(cmd1);
        this.setChar2(cmd2);
        int status = parser.read("AT Response Status");
        this.setStatus(AtCommandResponse.Status.get(status));
        this.setValue(parser.readRemainingBytes());
    }

    @Override
    public String toString() {
        return super.toString() + ",remoteAddress64=" + this.remoteAddress64 + ",remoteAddress16=" + this.remoteAddress16;
    }
}

