/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.SerialPortConnection;
import com.rapplogic.xbee.XBeeConnection;
import com.rapplogic.xbee.api.AtCommand;
import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.CollectTerminator;
import com.rapplogic.xbee.api.HardwareVersion;
import com.rapplogic.xbee.api.IXBee;
import com.rapplogic.xbee.api.InputStreamThread;
import com.rapplogic.xbee.api.PacketListener;
import com.rapplogic.xbee.api.PacketParser;
import com.rapplogic.xbee.api.XBeeConfiguration;
import com.rapplogic.xbee.api.XBeeException;
import com.rapplogic.xbee.api.XBeeFrameIdResponse;
import com.rapplogic.xbee.api.XBeeNotConnectedException;
import com.rapplogic.xbee.api.XBeePacket;
import com.rapplogic.xbee.api.XBeeRequest;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.api.XBeeTimeoutException;
import com.rapplogic.xbee.util.ByteUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class XBee
implements IXBee {
    private static final Logger log = Logger.getLogger(XBee.class);
    private Object sendPacketBlock = new Object();
    private XBeeConnection xbeeConnection;
    private InputStreamThread parser;
    private XBeeConfiguration conf;
    private HardwareVersion.RadioType type;
    private int sequentialFrameId = 255;

    public XBee() {
        this(new XBeeConfiguration().withMaxQueueSize(100));
    }

    public XBee(XBeeConfiguration conf) {
        this.conf = conf;
        if (this.conf.isShutdownHook()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (XBee.this.isConnected()) {
                        log.info((Object)"ShutdownHook is closing connection");
                        XBee.this.close();
                    }
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doStartupChecks() throws XBeeException {
        try {
            AtCommandResponse vr;
            AtCommandResponse ap = this.sendAtCommand(new AtCommand("AP"));
            if (!ap.isOk()) {
                throw new XBeeException("Attempt to query AP parameter failed");
            }
            if (ap.getValue()[0] != 2) {
                log.warn((Object)"XBee radio is in API mode without escape characters (AP=1).  The radio must be configured in API mode with escape bytes (AP=2) for use with this library.");
                log.info((Object)"Attempting to set AP to 2");
                ap = this.sendAtCommand(new AtCommand("AP", 2));
                if (!ap.isOk()) throw new XBeeException("Attempt to set AP=2 failed");
                log.info((Object)"Successfully set AP mode to 2.  This setting will not persist a power cycle without the WR (write) command");
            } else {
                log.info((Object)"Radio is in correct AP mode (AP=2)");
            }
            ap = this.sendAtCommand(new AtCommand("HV"));
            HardwareVersion.RadioType radioType = HardwareVersion.parse(ap);
            log.info((Object)("XBee radio is " + (Object)((Object)radioType)));
            if (radioType == HardwareVersion.RadioType.UNKNOWN) {
                log.warn((Object)("Unknown radio type (HV): " + ap.getValue()[0]));
            }
            if ((vr = this.sendAtCommand(new AtCommand("VR"))).isOk()) {
                log.info((Object)("Firmware version is " + ByteUtils.toBase16(vr.getValue())));
            }
            this.clearResponseQueue();
            return;
        }
        catch (XBeeTimeoutException ex) {
            throw new XBeeException("AT command timed-out while attempt to set/read in API mode.  Check that the XBee radio is in API mode (AP=2); it will not function propertly in AP=1");
        }
    }

    @Override
    public void open(String port, int baudRate) throws XBeeException {
        try {
            if (this.isConnected()) {
                throw new IllegalStateException("Cannot open new connection -- existing connection is still open.  Please close first");
            }
            this.type = null;
            SerialPortConnection serial = new SerialPortConnection();
            serial.openSerialPort(port, baudRate);
            this.initConnection(serial);
        }
        catch (XBeeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XBeeException(e);
        }
    }

    public static void registerResponseHandler(int apiId, Class<? extends XBeeResponse> clazz) {
        PacketParser.registerResponseHandler(apiId, clazz);
    }

    public static void unRegisterResponseHandler(int apiId) {
        PacketParser.unRegisterResponseHandler(apiId);
    }

    public void initProviderConnection(XBeeConnection connection) throws XBeeException {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot open new connection -- existing connection is still open.  Please close first");
        }
        this.initConnection(connection);
    }

    private void initConnection(XBeeConnection conn) throws XBeeException {
        try {
            this.xbeeConnection = conn;
            this.parser = new InputStreamThread(this.xbeeConnection, this.conf);
            if (this.conf.isStartupChecks()) {
                this.doStartupChecks();
            }
        }
        catch (XBeeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XBeeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPacketListener(PacketListener packetListener) {
        if (this.parser == null) {
            throw new IllegalStateException("No connection");
        }
        List<PacketListener> list = this.parser.getPacketListenerList();
        synchronized (list) {
            this.parser.getPacketListenerList().add(packetListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePacketListener(PacketListener packetListener) {
        if (this.parser == null) {
            throw new IllegalStateException("No connection");
        }
        List<PacketListener> list = this.parser.getPacketListenerList();
        synchronized (list) {
            this.parser.getPacketListenerList().remove(packetListener);
        }
    }

    public void sendRequest(XBeeRequest request) throws IOException {
        if (this.type != null) {
            if (this.type == HardwareVersion.RadioType.SERIES1 && request.getClass().getPackage().getName().indexOf("api.zigbee") > -1) {
                throw new IllegalArgumentException("You are connected to a Series 1 radio but attempting to send Series 2 requests");
            }
            if (this.type == HardwareVersion.RadioType.SERIES2 && request.getClass().getPackage().getName().indexOf("api.wpan") > -1) {
                throw new IllegalArgumentException("You are connected to a Series 2 radio but attempting to send Series 1 requests");
            }
        }
        log.info((Object)("Sending request to XBee: " + request));
        this.sendPacket(request.getXBeePacket());
    }

    @Override
    public void sendPacket(XBeePacket packet) throws IOException {
        this.sendPacket(packet.getByteArray());
    }

    @Override
    public void sendPacket(int[] packet) throws IOException {
        if (!this.isConnected()) {
            throw new XBeeNotConnectedException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Sending packet to XBee " + ByteUtils.toBase16(packet)));
        }
        for (int packetByte : packet) {
            this.xbeeConnection.getOutputStream().write(packetByte);
        }
        this.xbeeConnection.getOutputStream().flush();
    }

    @Override
    public void sendAsynchronous(XBeeRequest request) throws XBeeException {
        try {
            this.sendRequest(request);
        }
        catch (Exception e) {
            throw new XBeeException(e);
        }
    }

    public AtCommandResponse sendAtCommand(AtCommand command) throws XBeeException {
        return (AtCommandResponse)this.sendSynchronous(command, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XBeeResponse sendSynchronous(final XBeeRequest xbeeRequest, int timeout) throws XBeeTimeoutException, XBeeException {
        if (xbeeRequest.getFrameId() == 0) {
            throw new XBeeException("Frame Id cannot be 0 for a synchronous call -- it will always timeout as there is no response!");
        }
        PacketListener pl = null;
        try {
            final LinkedList container = new LinkedList();
            Serializable serializable = this.sendPacketBlock;
            synchronized (serializable) {
                this.sendRequest(xbeeRequest);
            }
            pl = new PacketListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processResponse(XBeeResponse response) {
                    if (response instanceof XBeeFrameIdResponse && ((XBeeFrameIdResponse)response).getFrameId() == xbeeRequest.getFrameId()) {
                        container.add(response);
                        List list = container;
                        synchronized (list) {
                            container.notify();
                        }
                    }
                }
            };
            this.addPacketListener(pl);
            serializable = container;
            synchronized (serializable) {
                try {
                    container.wait(timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (container.size() == 0) {
                throw new XBeeTimeoutException();
            }
            serializable = (XBeeResponse)container.get(0);
            if (pl != null) {
                this.removePacketListener(pl);
            }
            return serializable;
        }
        catch (IOException io) {
            try {
                throw new XBeeException(io);
            }
            catch (Throwable throwable) {
                if (pl != null) {
                    this.removePacketListener(pl);
                }
                throw throwable;
            }
        }
    }

    public XBeeResponse sendSynchronous(XBeeRequest request) throws XBeeTimeoutException, XBeeException {
        return this.sendSynchronous(request, this.conf.getSendSynchronousTimeout());
    }

    @Override
    public XBeeResponse getResponse() throws XBeeException {
        return this.getResponseTimeout(null);
    }

    @Override
    public XBeeResponse getResponse(int timeout) throws XBeeException, XBeeTimeoutException {
        return this.getResponseTimeout(timeout);
    }

    private XBeeResponse getResponseTimeout(Integer timeout) throws XBeeException, XBeeTimeoutException {
        XBeeResponse response;
        if (!this.isConnected()) {
            throw new XBeeNotConnectedException();
        }
        try {
            response = timeout != null ? this.parser.getResponseQueue().poll(timeout.intValue(), TimeUnit.MILLISECONDS) : this.parser.getResponseQueue().take();
        }
        catch (InterruptedException e) {
            throw new XBeeException("Error while attempting to remove packet from queue", e);
        }
        if (response == null && timeout > 0) {
            throw new XBeeTimeoutException();
        }
        return response;
    }

    @Override
    public List<? extends XBeeResponse> collectResponses(int wait, CollectTerminator terminator) throws XBeeException {
        if (!this.isConnected()) {
            throw new XBeeNotConnectedException();
        }
        long start = System.currentTimeMillis();
        long callStart = 0L;
        ArrayList<XBeeResponse> responseList = new ArrayList<XBeeResponse>();
        XBeeResponse response = null;
        try {
            int waitTime;
            while ((waitTime = wait - (int)(System.currentTimeMillis() - start)) > 0) {
                log.debug((Object)("calling getResponse with waitTime: " + waitTime));
                if (log.isDebugEnabled()) {
                    callStart = System.currentTimeMillis();
                }
                response = this.getResponse(waitTime);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got response in " + (System.currentTimeMillis() - callStart)));
                }
                responseList.add(response);
                if (terminator == null || !terminator.stop(response)) continue;
                log.debug((Object)"Found terminating response.. exiting");
                break;
            }
        }
        catch (XBeeTimeoutException e) {
        }
        catch (XBeeException e) {
            throw e;
        }
        log.debug((Object)("Time is up.. returning list with " + responseList.size() + " packets"));
        return responseList;
    }

    public List<? extends XBeeResponse> collectResponses(int wait) throws XBeeException {
        return this.collectResponses(wait, null);
    }

    public int getResponseQueueSize() {
        if (!this.isConnected()) {
            throw new XBeeNotConnectedException();
        }
        return this.parser.getResponseQueue().size();
    }

    @Override
    public void close() {
        if (!this.isConnected()) {
            throw new IllegalStateException("XBee is not connected");
        }
        if (this.parser != null) {
            this.parser.setDone(true);
            this.parser.interrupt();
        }
        try {
            this.xbeeConnection.close();
        }
        catch (IOException e) {
            log.warn((Object)"Failed to close connection", (Throwable)e);
        }
        this.type = null;
        this.parser = null;
        this.xbeeConnection = null;
    }

    @Override
    public boolean isConnected() {
        try {
            return this.parser.getXBeeConnection().getInputStream() != null && this.parser.getXBeeConnection().getOutputStream() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int getCurrentFrameId() {
        return this.sequentialFrameId;
    }

    @Override
    public int getNextFrameId() {
        this.sequentialFrameId = this.sequentialFrameId == 255 ? 1 : ++this.sequentialFrameId;
        return this.sequentialFrameId;
    }

    @Override
    public void updateFrameId(int val) {
        if (val <= 0 || val > 255) {
            throw new IllegalArgumentException("invalid frame id");
        }
        this.sequentialFrameId = val;
    }

    @Override
    public void clearResponseQueue() {
        if (!this.isConnected()) {
            throw new XBeeNotConnectedException();
        }
        this.parser.getResponseQueue().clear();
    }
}

