/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.XBeeAddress;
import java.util.Arrays;
import java.util.StringTokenizer;

public class XBeeAddress64
extends XBeeAddress {
    public static final XBeeAddress64 BROADCAST = new XBeeAddress64(new int[]{0, 0, 0, 0, 0, 0, 255, 255});
    public static final XBeeAddress64 ZNET_COORDINATOR = new XBeeAddress64(new int[]{0, 0, 0, 0, 0, 0, 0, 0});
    private int[] address;

    public XBeeAddress64(String addressStr) {
        this.address = new int[8];
        if (addressStr.contains(" ")) {
            StringTokenizer st = new StringTokenizer(addressStr, " ");
            for (int i = 0; i < this.address.length; ++i) {
                String byteStr = st.nextToken();
                this.address[i] = Integer.parseInt(byteStr, 16);
            }
        } else {
            for (int i = 0; i < this.address.length; ++i) {
                this.address[i] = Integer.parseInt(addressStr.substring(i * 2, i * 2 + 2), 16);
            }
        }
    }

    public XBeeAddress64(int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8) {
        this.address = new int[8];
        this.address[0] = b1;
        this.address[1] = b2;
        this.address[2] = b3;
        this.address[3] = b4;
        this.address[4] = b5;
        this.address[5] = b6;
        this.address[6] = b7;
        this.address[7] = b8;
    }

    public XBeeAddress64(int[] address) {
        this.address = address;
    }

    public XBeeAddress64() {
        this.address = new int[8];
    }

    public void setAddress(int[] address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XBeeAddress64 that = (XBeeAddress64)o;
        return Arrays.equals(this.address, that.address);
    }

    public int hashCode() {
        return this.address != null ? Arrays.hashCode(this.address) : 0;
    }

    @Override
    public int[] getAddress() {
        return this.address;
    }
}

