/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.NoRequestResponse;
import com.rapplogic.xbee.api.ResponseFilter;
import com.rapplogic.xbee.api.XBeeResponse;

public class XBeeConfiguration {
    private boolean shutdownHook = false;
    private boolean startupChecks = false;
    private int maxQueueSize = 100;
    private int sendSynchronousTimeout = 5000;
    private ResponseFilter responseQueueFilter;
    private final ResponseFilter noRequestResponseQueueFilter = new ResponseFilter(){

        @Override
        public boolean accept(XBeeResponse response) {
            return response instanceof NoRequestResponse;
        }
    };

    public XBeeConfiguration withShutdownHook(boolean shutdownHook) {
        this.shutdownHook = shutdownHook;
        return this;
    }

    public XBeeConfiguration withStartupChecks(boolean startupChecks) {
        this.startupChecks = startupChecks;
        return this;
    }

    public XBeeConfiguration withMaxQueueSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        this.maxQueueSize = size;
        return this;
    }

    public XBeeConfiguration withResponseQueueFilter(ResponseFilter filter) {
        this.responseQueueFilter = filter;
        return this;
    }

    public XBeeConfiguration withSendSynchronousTimeout(int sendSynchronousTimeout) {
        this.sendSynchronousTimeout = sendSynchronousTimeout;
        return this;
    }

    public XBeeConfiguration withNoRequestResponseQueueFilter() {
        this.responseQueueFilter = this.noRequestResponseQueueFilter;
        return this;
    }

    public boolean isStartupChecks() {
        return this.startupChecks;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public ResponseFilter getResponseQueueFilter() {
        return this.responseQueueFilter;
    }

    public int getSendSynchronousTimeout() {
        return this.sendSynchronousTimeout;
    }

    public boolean isShutdownHook() {
        return this.shutdownHook;
    }
}

