/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.Checksum;
import com.rapplogic.xbee.api.XBeePacketLength;
import com.rapplogic.xbee.util.ByteUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class XBeePacket {
    private static final Logger log = Logger.getLogger(XBeePacket.class);
    private int[] packet;

    public XBeePacket(int[] frameData) {
        Checksum checksum = new Checksum();
        for (int aFrameData : frameData) {
            checksum.addByte(aFrameData);
        }
        checksum.compute();
        this.packet = new int[frameData.length + 4];
        this.packet[0] = SpecialByte.START_BYTE.getValue();
        XBeePacketLength length = new XBeePacketLength(frameData.length);
        this.packet[1] = length.getMsb();
        this.packet[2] = length.getLsb();
        for (int i = 0; i < frameData.length; ++i) {
            if (frameData[i] > 255) {
                throw new RuntimeException("Packet values must not be greater than one byte (255): " + frameData[i]);
            }
            this.packet[3 + i] = frameData[i];
        }
        this.packet[this.packet.length - 1] = checksum.getChecksum();
        int preEscapeLength = this.packet.length;
        this.packet = XBeePacket.escapePacket(this.packet);
        if (log.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Packet: ");
            for (int i = 0; i < this.packet.length; ++i) {
                stringBuilder.append(ByteUtils.toBase16(this.packet[i]));
                if (i >= this.packet.length - 1) continue;
                stringBuilder.append(" ");
            }
            log.debug((Object)stringBuilder);
            log.debug((Object)("pre-escape packet size is " + preEscapeLength + ", post-escape packet size is " + this.packet.length));
        }
    }

    private static int[] escapePacket(int[] packet) {
        int escapeBytes = 0;
        for (int i = 1; i < packet.length; ++i) {
            if (!XBeePacket.isSpecialByte(packet[i])) continue;
            log.debug((Object)("escapeFrameData: packet byte requires escaping byte " + ByteUtils.toBase16(packet[i])));
            ++escapeBytes;
        }
        if (escapeBytes == 0) {
            return packet;
        }
        log.debug((Object)"packet requires escaping");
        int[] escapePacket = new int[packet.length + escapeBytes];
        int pos = 1;
        escapePacket[0] = SpecialByte.START_BYTE.getValue();
        for (int i = 1; i < packet.length; ++i) {
            if (XBeePacket.isSpecialByte(packet[i])) {
                escapePacket[pos] = SpecialByte.ESCAPE.getValue();
                escapePacket[++pos] = 0x20 ^ packet[i];
                log.debug((Object)("escapeFrameData: xor'd byte is 0x" + Integer.toHexString(escapePacket[pos])));
            } else {
                escapePacket[pos] = packet[i];
            }
            ++pos;
        }
        return escapePacket;
    }

    public int[] getPacket() {
        return this.getByteArray();
    }

    public int[] getByteArray() {
        return this.packet;
    }

    public static boolean isSpecialByte(int b) {
        return b == SpecialByte.START_BYTE.getValue() || b == SpecialByte.ESCAPE.getValue() || b == SpecialByte.XON.getValue() || b == SpecialByte.XOFF.getValue();
    }

    public String toString() {
        return ByteUtils.toBase16(this.packet);
    }

    public static int getPacketLength(int[] packet) {
        return new XBeePacketLength(packet[1], packet[2]).getLength();
    }

    public static boolean verify(int[] packet) {
        boolean valid = true;
        try {
            if (packet[0] != SpecialByte.START_BYTE.getValue()) {
                return false;
            }
            if (XBeePacket.packetEndsWithEscapeByte(packet)) {
                return false;
            }
            int[] unEscaped = XBeePacket.unEscapePacket(packet);
            if (unEscaped.length < 3) {
                return false;
            }
            int len = XBeePacket.getPacketLength(unEscaped);
            int expectedPacketLength = len + 4;
            if (unEscaped.length != expectedPacketLength) {
                return false;
            }
            int[] frameData = new int[len];
            Checksum checksum = new Checksum();
            for (int i = 3; i < unEscaped.length - 1; ++i) {
                frameData[i - 3] = unEscaped[i];
                checksum.addByte(frameData[i - 3]);
            }
            checksum.addByte(unEscaped[unEscaped.length - 1]);
            if (!checksum.verify()) {
                valid = false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Packet verification failed with error: ", e);
        }
        return valid;
    }

    public static boolean packetEndsWithEscapeByte(int[] packet) {
        return packet[packet.length - 1] == SpecialByte.ESCAPE.getValue();
    }

    public static int[] unEscapePacket(int[] packet) {
        int escapeBytes = 0;
        if (XBeePacket.packetEndsWithEscapeByte(packet)) {
            throw new RuntimeException("Invalid packet -- packet cannot end with an escape byte " + ByteUtils.toBase16(packet));
        }
        for (int b : packet) {
            if (b != SpecialByte.ESCAPE.getValue()) continue;
            ++escapeBytes;
        }
        if (escapeBytes == 0) {
            return packet;
        }
        int[] unEscapedPacket = new int[packet.length - escapeBytes];
        int pos = 0;
        for (int i = 0; i < packet.length; ++i) {
            if (packet[i] == SpecialByte.ESCAPE.getValue()) {
                if (i >= packet.length - 1) {
                    return packet;
                }
                unEscapedPacket[pos] = 0x20 ^ packet[++i];
            } else {
                unEscapedPacket[pos] = packet[i];
            }
            ++pos;
        }
        return unEscapedPacket;
    }

    public static enum SpecialByte {
        START_BYTE(126),
        ESCAPE(125),
        XON(17),
        XOFF(19);

        private static final Map<Integer, SpecialByte> lookup;
        private final int value;

        public static SpecialByte get(int value) {
            return lookup.get(value);
        }

        private SpecialByte(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, SpecialByte>();
            for (SpecialByte s : EnumSet.allOf(SpecialByte.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

