/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.XBeePacket;
import com.rapplogic.xbee.api.XBeePacketLength;
import com.rapplogic.xbee.util.ByteUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public abstract class XBeeResponse
implements Serializable {
    private static final long serialVersionUID = -7038123612643874495L;
    private int[] rawPacketBytes;
    private int[] processedPacketBytes;
    private ApiId apiId;
    private int checksum;
    private XBeePacketLength length;
    private boolean error = false;

    public XBeePacketLength getLength() {
        return this.length;
    }

    public void setLength(XBeePacketLength length) {
        this.length = length;
    }

    public ApiId getApiId() {
        return this.apiId;
    }

    public void setApiId(ApiId apiId) {
        this.apiId = apiId;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public void setChecksum(int checksum) {
        this.checksum = checksum;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public int[] getPacketBytes() {
        return this.getRawPacketBytes();
    }

    public int[] getRawPacketBytes() {
        return this.rawPacketBytes;
    }

    public int[] getProcessedPacketBytes() {
        return this.processedPacketBytes;
    }

    public void setRawPacketBytes(int[] packetBytes) {
        this.rawPacketBytes = packetBytes;
        this.processedPacketBytes = XBeePacket.unEscapePacket(packetBytes);
    }

    public void finish() {
    }

    protected abstract void parse(IPacketParser var1) throws IOException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.apiId == null ? 0 : this.apiId.hashCode());
        result = 31 * result + this.checksum;
        result = 31 * result + (this.error ? 1231 : 1237);
        result = 31 * result + (this.length == null ? 0 : this.length.hashCode());
        result = 31 * result + Arrays.hashCode(this.rawPacketBytes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XBeeResponse other = (XBeeResponse)obj;
        if (this.apiId == null ? other.apiId != null : !this.apiId.equals((Object)other.apiId)) {
            return false;
        }
        if (this.checksum != other.checksum) {
            return false;
        }
        if (this.error != other.error) {
            return false;
        }
        if (this.length == null ? other.length != null : !this.length.equals(other.length)) {
            return false;
        }
        return Arrays.equals(this.rawPacketBytes, other.rawPacketBytes);
    }

    public String toString() {
        return "apiId=" + (Object)((Object)this.apiId) + ",length=" + (this.length == null ? "null" : Integer.valueOf(this.length.get16BitValue())) + ",checksum=" + ByteUtils.toBase16(this.checksum) + ",error=" + this.error;
    }
}

