/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.wpan;

import com.rapplogic.xbee.api.wpan.RxResponseIoSample;
import com.rapplogic.xbee.util.ByteUtils;

public class IoSample {
    private RxResponseIoSample parent;
    private Integer dioMsb;
    private Integer dioLsb;
    private Integer[] analog = new Integer[6];

    public IoSample(RxResponseIoSample parent) {
        this.parent = parent;
    }

    public void setDioMsb(Integer dioMsb) {
        this.dioMsb = dioMsb;
    }

    public void setDioLsb(Integer dioLsb) {
        this.dioLsb = dioLsb;
    }

    public Integer getDioMsb() {
        return this.dioMsb;
    }

    public Integer getDioLsb() {
        return this.dioLsb;
    }

    public Integer getAnalog(int pin) {
        if (this.parent.isAnalogEnabled(pin)) {
            return this.analog[pin];
        }
        return null;
    }

    public Integer getAnalog0() {
        return this.getAnalog(0);
    }

    public void setAnalog0(Integer analog0) {
        this.analog[0] = analog0;
    }

    public Integer getAnalog1() {
        return this.getAnalog(1);
    }

    public void setAnalog1(Integer analog1) {
        this.analog[1] = analog1;
    }

    public Integer getAnalog2() {
        return this.getAnalog(2);
    }

    public void setAnalog2(Integer analog2) {
        this.analog[2] = analog2;
    }

    public Integer getAnalog3() {
        return this.getAnalog(3);
    }

    public void setAnalog3(Integer analog3) {
        this.analog[3] = analog3;
    }

    public Integer getAnalog4() {
        return this.getAnalog(4);
    }

    public void setAnalog4(Integer analog4) {
        this.analog[4] = analog4;
    }

    public Integer getAnalog5() {
        return this.getAnalog(5);
    }

    public void setAnalog5(Integer analog5) {
        this.analog[5] = analog5;
    }

    public Boolean isDigitalOn(int pin) {
        if (!this.parent.isDigitalEnabled(pin)) {
            return null;
        }
        if (pin >= 0 && pin <= 7) {
            return ByteUtils.getBit(this.dioLsb, pin + 1);
        }
        return ByteUtils.getBit(this.dioMsb, 1);
    }

    public Boolean isD0On() {
        return this.isDigitalOn(0);
    }

    public Boolean isD1On() {
        return this.isDigitalOn(1);
    }

    public Boolean isD2On() {
        return this.isDigitalOn(2);
    }

    public Boolean isD3On() {
        return this.isDigitalOn(3);
    }

    public Boolean isD4On() {
        return this.isDigitalOn(4);
    }

    public Boolean isD5On() {
        return this.isDigitalOn(5);
    }

    public Boolean isD6On() {
        return this.isDigitalOn(6);
    }

    public Boolean isD7On() {
        return this.isDigitalOn(7);
    }

    public Boolean isD8On() {
        return this.isDigitalOn(8);
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        if (this.parent.containsDigital()) {
            for (i = 0; i <= 8; ++i) {
                if (!this.parent.isDigitalEnabled(i)) continue;
                builder.append(",digital[" + i + "]=" + (this.isDigitalOn(i) != false ? "high" : "low"));
            }
        }
        if (this.parent.containsAnalog()) {
            for (i = 0; i <= 5; ++i) {
                if (!this.parent.isAnalogEnabled(i)) continue;
                builder.append(",analog[" + i + "]=" + this.getAnalog(i));
            }
        }
        return builder.toString();
    }
}

