/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.wpan;

import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.XBeeAddress;
import com.rapplogic.xbee.api.XBeeResponse;
import com.rapplogic.xbee.util.ByteUtils;
import java.io.IOException;

public abstract class RxBaseResponse
extends XBeeResponse {
    private XBeeAddress sourceAddress;
    private int rssi;
    private int options;

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public boolean isAddressBroadcast() {
        return ByteUtils.getBit(this.options, 2);
    }

    public boolean isPanBroadcast() {
        return ByteUtils.getBit(this.options, 3);
    }

    public XBeeAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public void setSourceAddress(XBeeAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    protected void parseBase(IPacketParser parser) throws IOException {
        int rssi = parser.read("RSSI");
        this.setRssi(-rssi);
        int options = parser.read("Options");
        this.setOptions(options);
    }

    @Override
    public String toString() {
        return super.toString() + ",sourceAddress=" + this.getSourceAddress() + ",rssi=" + this.getRssi() + ",options=" + this.getOptions() + ",isAddressBroadcast=" + this.isAddressBroadcast() + ",isPanBroadcast=" + this.isPanBroadcast();
    }
}

