/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.wpan;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.NoRequestResponse;
import com.rapplogic.xbee.api.wpan.IoSample;
import com.rapplogic.xbee.api.wpan.RxBaseResponse;
import com.rapplogic.xbee.util.ByteUtils;
import com.rapplogic.xbee.util.IIntInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RxResponseIoSample
extends RxBaseResponse
implements NoRequestResponse {
    private static final Logger log = Logger.getLogger(RxResponseIoSample.class);
    public static final int ADC_CHANNEL1 = 126;
    public static final int DIO_CHANNEL1 = 1;
    private IoSample[] samples;
    private int channelIndicator1;
    private int channelIndicator2;

    @Override
    public void parse(IPacketParser parser) throws IOException {
        if (parser.getApiId() == ApiId.RX_16_IO_RESPONSE) {
            this.setSourceAddress(parser.parseAddress16());
        } else {
            this.setSourceAddress(parser.parseAddress64());
        }
        super.parseBase(parser);
        log.debug((Object)"this is a I/O sample!");
        int sampleSize = parser.read("# I/O Samples");
        this.setSamples(new IoSample[sampleSize]);
        this.setChannelIndicator1(parser.read("Channel Indicator 1"));
        log.debug((Object)("channel indicator 1 is " + ByteUtils.formatByte(this.getChannelIndicator1())));
        this.setChannelIndicator2(parser.read("Channel Indicator 2"));
        log.debug((Object)("channel indicator 2 is " + ByteUtils.formatByte(this.getChannelIndicator2())));
        for (int i = 0; i < this.getSamples().length; ++i) {
            IoSample sample;
            log.debug((Object)("parsing sample " + (i + 1)));
            this.getSamples()[i] = sample = this.parseIoSample((IIntInputStream)((Object)parser));
        }
    }

    private IoSample parseIoSample(IIntInputStream parser) throws IOException {
        IoSample sample = new IoSample(this);
        if (this.containsDigital()) {
            log.debug((Object)"Digital I/O was received");
            sample.setDioMsb(parser.read("DIO MSB"));
            sample.setDioLsb(parser.read("DIO LSB"));
        }
        if (this.containsAnalog()) {
            log.debug((Object)"Analog input was received");
            int analog = 0;
            if (this.isA0Enabled()) {
                sample.setAnalog0(ByteUtils.parse10BitAnalog(parser, analog));
                ++analog;
            }
            if (this.isA1Enabled()) {
                sample.setAnalog1(ByteUtils.parse10BitAnalog(parser, analog));
                ++analog;
            }
            if (this.isA2Enabled()) {
                sample.setAnalog2(ByteUtils.parse10BitAnalog(parser, analog));
                ++analog;
            }
            if (this.isA3Enabled()) {
                sample.setAnalog3(ByteUtils.parse10BitAnalog(parser, analog));
                ++analog;
            }
            if (this.isA4Enabled()) {
                sample.setAnalog4(ByteUtils.parse10BitAnalog(parser, analog));
                ++analog;
            }
            if (this.isA5Enabled()) {
                sample.setAnalog5(ByteUtils.parse10BitAnalog(parser, analog));
                ++analog;
            }
            log.debug((Object)("There are " + analog + " analog inputs turned on"));
        }
        return sample;
    }

    public IoSample[] getSamples() {
        return this.samples;
    }

    public void setSamples(IoSample[] samples) {
        this.samples = samples;
    }

    public boolean isDigitalEnabled(int pin) {
        if (pin >= 0 && pin <= 7) {
            return ByteUtils.getBit(this.channelIndicator2, pin + 1);
        }
        if (pin == 8) {
            return ByteUtils.getBit(this.channelIndicator1, 1);
        }
        throw new IllegalArgumentException("Unsupported pin: " + pin);
    }

    public boolean isD0Enabled() {
        return ByteUtils.getBit(this.channelIndicator2, 1);
    }

    public boolean isD1Enabled() {
        return ByteUtils.getBit(this.channelIndicator2, 2);
    }

    public boolean isD2Enabled() {
        return ByteUtils.getBit(this.channelIndicator2, 3);
    }

    public boolean isD3Enabled() {
        return ByteUtils.getBit(this.channelIndicator2, 4);
    }

    public boolean isD4Enabled() {
        return ByteUtils.getBit(this.channelIndicator2, 5);
    }

    public boolean isD5Enabled() {
        return ByteUtils.getBit(this.channelIndicator2, 6);
    }

    public boolean isD6Enabled() {
        return ByteUtils.getBit(this.channelIndicator2, 7);
    }

    public boolean isD7Enabled() {
        return ByteUtils.getBit(this.channelIndicator2, 8);
    }

    public boolean isD8Enabled() {
        return ByteUtils.getBit(this.channelIndicator1, 1);
    }

    public boolean isAnalogEnabled(int pin) {
        if (pin >= 0 && pin <= 5) {
            return ByteUtils.getBit(this.channelIndicator1, pin + 2);
        }
        throw new IllegalArgumentException("Unsupported pin: " + pin);
    }

    public boolean isA0Enabled() {
        return ByteUtils.getBit(this.channelIndicator1, 2);
    }

    public boolean isA1Enabled() {
        return ByteUtils.getBit(this.channelIndicator1, 3);
    }

    public boolean isA2Enabled() {
        return ByteUtils.getBit(this.channelIndicator1, 4);
    }

    public boolean isA3Enabled() {
        return ByteUtils.getBit(this.channelIndicator1, 5);
    }

    public boolean isA4Enabled() {
        return ByteUtils.getBit(this.channelIndicator1, 6);
    }

    public boolean isA5Enabled() {
        return ByteUtils.getBit(this.channelIndicator1, 7);
    }

    public int getChannelIndicator1() {
        return this.channelIndicator1;
    }

    public void setChannelIndicator1(int channelIndicator1) {
        this.channelIndicator1 = channelIndicator1;
    }

    public int getChannelIndicator2() {
        return this.channelIndicator2;
    }

    public void setChannelIndicator2(int channelIndicator2) {
        this.channelIndicator2 = channelIndicator2;
    }

    public boolean containsAnalog() {
        return (this.channelIndicator1 & 0x7E) > 0;
    }

    public boolean containsDigital() {
        return (this.channelIndicator1 & 1) > 0 || this.channelIndicator2 > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(",#samples=" + this.samples.length);
        for (int i = 0; i < this.samples.length; ++i) {
            sb.append(",Sample#" + (i + 1) + ":" + this.samples[i].toString() + "]");
        }
        return sb.toString();
    }
}

