/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.wpan;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.wpan.TxRequestBase;
import com.rapplogic.xbee.util.IntArrayOutputStream;

public class TxRequest16
extends TxRequestBase {
    private XBeeAddress16 remoteAddr16;

    public TxRequest16(XBeeAddress16 remoteAddr16, int[] payload) {
        this(remoteAddr16, 1, TxRequestBase.Option.UNICAST, payload);
    }

    public TxRequest16(XBeeAddress16 remoteAddr16, int frameId, int[] payload) {
        this(remoteAddr16, frameId, TxRequestBase.Option.UNICAST, payload);
    }

    public TxRequest16(XBeeAddress16 remoteAddr16, int frameId, TxRequestBase.Option option, int[] payload) {
        this.remoteAddr16 = remoteAddr16;
        this.setFrameId(frameId);
        this.setOption(option);
        this.setPayload(payload);
    }

    @Override
    public int[] getFrameData() {
        IntArrayOutputStream out = new IntArrayOutputStream();
        out.write(this.getApiId().getValue());
        out.write(this.getFrameId());
        out.write(this.remoteAddr16.getAddress());
        out.write(this.getOption().getValue());
        out.write(this.getPayload());
        return out.getIntArray();
    }

    @Override
    public ApiId getApiId() {
        return ApiId.TX_REQUEST_16;
    }

    public XBeeAddress16 getRemoteAddr16() {
        return this.remoteAddr16;
    }

    public void setRemoteAddr16(XBeeAddress16 remoteAddr16) {
        this.remoteAddr16 = remoteAddr16;
    }

    @Override
    public String toString() {
        return super.toString() + ",remoteAddress16=" + this.remoteAddr16;
    }
}

