/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.wpan;

import com.rapplogic.xbee.api.ApiId;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.api.wpan.TxRequestBase;
import com.rapplogic.xbee.util.IntArrayOutputStream;

public class TxRequest64
extends TxRequestBase {
    private XBeeAddress64 remoteAddr64;

    public TxRequest64(XBeeAddress64 destination, int[] payload) {
        this(destination, 1, TxRequestBase.Option.UNICAST, payload);
    }

    public TxRequest64(XBeeAddress64 destination, int frameId, int[] payload) {
        this(destination, frameId, TxRequestBase.Option.UNICAST, payload);
    }

    public TxRequest64(XBeeAddress64 remoteAddr64, int frameId, TxRequestBase.Option option, int[] payload) {
        this.remoteAddr64 = remoteAddr64;
        this.setFrameId(frameId);
        this.setOption(option);
        this.setPayload(payload);
    }

    @Override
    public int[] getFrameData() {
        IntArrayOutputStream out = new IntArrayOutputStream();
        out.write(this.getApiId().getValue());
        out.write(this.getFrameId());
        out.write(this.remoteAddr64.getAddress());
        out.write(this.getOption().getValue());
        out.write(this.getPayload());
        return out.getIntArray();
    }

    @Override
    public ApiId getApiId() {
        return ApiId.TX_REQUEST_64;
    }

    public XBeeAddress64 getRemoteAddr64() {
        return this.remoteAddr64;
    }

    public void setRemoteAddr64(XBeeAddress64 remoteAddr64) {
        this.remoteAddr64 = remoteAddr64;
    }

    @Override
    public String toString() {
        return super.toString() + ",remoteAddress64=" + this.remoteAddr64.toString();
    }
}

