/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.wpan;

import com.rapplogic.xbee.api.XBeeRequest;
import com.rapplogic.xbee.util.ByteUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public abstract class TxRequestBase
extends XBeeRequest {
    public static final int MAX_PAYLOAD_SIZE = 100;
    private int maxPayloadSize;
    private int[] payload;
    private Option option;

    public int[] getPayload() {
        return this.payload;
    }

    public void setPayload(int[] payload) {
        if (this.getMaxPayloadSize() > 0 && payload.length > this.getMaxPayloadSize()) {
            throw new IllegalArgumentException("Payload exceeds user-defined maximum payload size of " + this.getMaxPayloadSize() + " bytes.  Please re-package into multiple packets");
        }
        this.payload = payload;
    }

    public Option getOption() {
        return this.option;
    }

    public void setOption(Option option) {
        this.option = option;
    }

    @Override
    public String toString() {
        return super.toString() + ",option=" + (Object)((Object)this.option) + ",payload=" + ByteUtils.toBase16(this.payload);
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public void setMaxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    public static enum Option {
        UNICAST(0),
        DISABLE_ACK(1),
        BROADCAST(4);

        private static final Map<Integer, Option> lookup;
        private final int value;

        public static Option get(int value) {
            return lookup.get(value);
        }

        private Option(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, Option>();
            for (Option s : EnumSet.allOf(Option.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

