/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.wpan;

import com.rapplogic.xbee.api.IPacketParser;
import com.rapplogic.xbee.api.XBeeFrameIdResponse;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class TxStatusResponse
extends XBeeFrameIdResponse {
    private Status status;

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    public boolean isAckError() {
        return this.status == Status.NO_ACK;
    }

    public boolean isCcaError() {
        return this.status == Status.CCA_FAILURE;
    }

    public boolean isPurged() {
        return this.status == Status.PURGED;
    }

    @Override
    public void parse(IPacketParser parser) throws IOException {
        int frameId = parser.read("TxStatus Frame Id");
        this.setFrameId(frameId);
        int status = parser.read("TX Status");
        this.setStatus(Status.get(status));
    }

    @Override
    public String toString() {
        return super.toString() + ",status=" + (Object)((Object)this.getStatus());
    }

    public static enum Status {
        SUCCESS(0),
        NO_ACK(1),
        CCA_FAILURE(2),
        PURGED(3);

        private static final Map<Integer, Status> lookup;
        private final int value;

        public static Status get(int value) {
            return lookup.get(value);
        }

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static {
            lookup = new HashMap<Integer, Status>();
            for (Status s : EnumSet.allOf(Status.class)) {
                lookup.put(s.getValue(), s);
            }
        }
    }
}

