/*
 * Decompiled with CFR 0.152.
 */
package com.rapplogic.xbee.api.wpan;

import com.rapplogic.xbee.api.AtCommandResponse;
import com.rapplogic.xbee.api.XBeeAddress16;
import com.rapplogic.xbee.api.XBeeAddress64;
import com.rapplogic.xbee.util.IntArrayInputStream;
import org.apache.log4j.Logger;

public class WpanNodeDiscover {
    private static final Logger log = Logger.getLogger(WpanNodeDiscover.class);
    private XBeeAddress16 nodeAddress16;
    private XBeeAddress64 nodeAddress64;
    private int rssi;
    private String nodeIdentifier;

    public static WpanNodeDiscover parse(AtCommandResponse response) {
        int ch;
        if (!response.getCommand().equals("ND")) {
            throw new IllegalArgumentException("This method is only applicable for the ND command");
        }
        int[] data = response.getValue();
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("ND command has no value");
        }
        IntArrayInputStream in = new IntArrayInputStream(data);
        WpanNodeDiscover nd = new WpanNodeDiscover();
        nd.setNodeAddress16(new XBeeAddress16(in.read(2)));
        nd.setNodeAddress64(new XBeeAddress64(in.read(8)));
        nd.setRssi(-1 * in.read());
        StringBuilder ni = new StringBuilder();
        while ((ch = in.read()) != 0) {
            if (ch < 32 || ch > 126) {
                throw new RuntimeException("Node Identifier " + ch + " is non-ascii");
            }
            ni.append((char)ch);
        }
        nd.setNodeIdentifier(ni.toString());
        return nd;
    }

    public String toString() {
        return "nodeAddress16=" + this.nodeAddress16 + ", nodeAddress64=" + this.nodeAddress64 + ", rssi=" + this.rssi + ", nodeIdentifier=" + this.nodeIdentifier;
    }

    public XBeeAddress16 getNodeAddress16() {
        return this.nodeAddress16;
    }

    public void setNodeAddress16(XBeeAddress16 my) {
        this.nodeAddress16 = my;
    }

    public XBeeAddress64 getNodeAddress64() {
        return this.nodeAddress64;
    }

    public void setNodeAddress64(XBeeAddress64 serial) {
        this.nodeAddress64 = serial;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public void setNodeIdentifier(String nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }
}

